/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.factory;

import java.util.List;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.context.ChainedTilesRequestContextFactory;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.factory.BasicTilesContainerFactory;
import org.apache.tiles.renderer.AttributeRenderer;
import org.apache.tiles.renderer.TypeDetectingAttributeRenderer;
import org.apache.tiles.renderer.impl.AbstractTypeDetectingAttributeRenderer;
import org.apache.tiles.renderer.impl.BasicRendererFactory;
import org.apache.tiles.renderer.impl.ChainedDelegateAttributeRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.extras.tiles2.context.ThymeleafTilesRequestContextFactory;
import org.thymeleaf.extras.tiles2.renderer.MetadataCleaningAttributeRendererWrapper;
import org.thymeleaf.extras.tiles2.renderer.ThymeleafAttributeRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThymeleafTilesContainerFactory
extends BasicTilesContainerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ThymeleafTilesContainerFactory.class);
    public static final String THYMELEAF_RENDERER_NAME = "thymeleaf";
    public static final String JSP_RENDERER_NAME = "jsp";

    public ThymeleafTilesContainerFactory() {
        if (logger.isDebugEnabled()) {
            logger.debug("[THYMELEAF] INITIALIZING TILES CONTAINER FACTORY FOR THYMELEAF. AVAILABLE TEMPLATE TYPES ARE: \"thymeleaf\" (default), \"jsp\" AND \"string\"");
        }
    }

    protected void registerAttributeRenderers(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        super.registerAttributeRenderers(rendererFactory, applicationContext, contextFactory, container, attributeEvaluatorFactory);
        rendererFactory.registerRenderer(JSP_RENDERER_NAME, rendererFactory.getRenderer("template"));
        rendererFactory.registerRenderer(JSP_RENDERER_NAME, (AttributeRenderer)new MetadataCleaningAttributeRendererWrapper((AbstractTypeDetectingAttributeRenderer)rendererFactory.getRenderer(JSP_RENDERER_NAME)));
        rendererFactory.registerRenderer("string", (AttributeRenderer)new MetadataCleaningAttributeRendererWrapper((AbstractTypeDetectingAttributeRenderer)rendererFactory.getRenderer("string")));
        MetadataCleaningAttributeRendererWrapper thymeleafAttributeRenderer = new MetadataCleaningAttributeRendererWrapper((AbstractTypeDetectingAttributeRenderer)this.createThymeleafAttributeRenderer(rendererFactory, applicationContext, contextFactory, container, attributeEvaluatorFactory));
        rendererFactory.registerRenderer(THYMELEAF_RENDERER_NAME, (AttributeRenderer)thymeleafAttributeRenderer);
        rendererFactory.registerRenderer("template", (AttributeRenderer)thymeleafAttributeRenderer);
    }

    protected AttributeRenderer createThymeleafAttributeRenderer(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        ThymeleafAttributeRenderer renderer = new ThymeleafAttributeRenderer();
        renderer.setApplicationContext(applicationContext);
        renderer.setRequestContextFactory(contextFactory);
        renderer.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        return renderer;
    }

    protected AttributeRenderer createDefaultAttributeRenderer(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        ChainedDelegateAttributeRenderer chain = new ChainedDelegateAttributeRenderer();
        chain.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer("definition"));
        chain.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer(THYMELEAF_RENDERER_NAME));
        chain.setApplicationContext(applicationContext);
        chain.setRequestContextFactory(contextFactory);
        chain.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        return chain;
    }

    protected List<TilesRequestContextFactory> getTilesRequestContextFactoriesToBeChained(ChainedTilesRequestContextFactory parent) {
        List factories = super.getTilesRequestContextFactoriesToBeChained(parent);
        this.registerRequestContextFactory(ThymeleafTilesRequestContextFactory.class.getName(), factories, (TilesRequestContextFactory)parent);
        return factories;
    }
}

