/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.spring4.web.view;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.servlet.context.ServletUtil;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.DialectAwareProcessingContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.extras.tiles2.spring4.web.configurer.ThymeleafTilesConfigurer;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.context.SpringWebContext;
import org.thymeleaf.spring4.expression.ThymeleafEvaluationContext;
import org.thymeleaf.spring4.view.AbstractThymeleafView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThymeleafTilesView
extends AbstractThymeleafView {
    private static final String pathVariablesSelector;

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = this.getServletContext();
        if (this.getTemplateName() == null) {
            throw new IllegalArgumentException("Property 'templateName' is required");
        }
        if (this.getTemplateEngine() == null) {
            throw new IllegalArgumentException("Property 'templateEngine' is required");
        }
        SpringTemplateEngine viewTemplateEngine = this.getTemplateEngine();
        IProcessingContext processingContext = this.buildContextAndPrepareResponse((TemplateEngine)viewTemplateEngine, model, request, response);
        TilesContainer container = ServletUtil.getContainer((ServletContext)servletContext);
        if (container == null) {
            throw new ServletException("Tiles container is not initialized. Have you added a " + ThymeleafTilesConfigurer.class.getSimpleName() + " to " + "your web application context?");
        }
        container.render(this.getTemplateName(), new Object[]{viewTemplateEngine, processingContext, request, response, response.getWriter()});
    }

    protected IProcessingContext buildContextAndPrepareResponse(TemplateEngine templateEngine, Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map pathVars;
        ServletContext servletContext = this.getServletContext();
        if (this.getLocale() == null) {
            throw new IllegalArgumentException("Property 'locale' is required");
        }
        HashMap<String, Object> mergedModel = new HashMap<String, Object>(30);
        Map templateStaticVariables = this.getStaticVariables();
        if (templateStaticVariables != null) {
            mergedModel.putAll(templateStaticVariables);
        }
        if (pathVariablesSelector != null && (pathVars = (Map)request.getAttribute(pathVariablesSelector)) != null) {
            mergedModel.putAll(pathVars);
        }
        if (model != null) {
            mergedModel.putAll(model);
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        RequestContext requestContext = new RequestContext(request, response, servletContext, mergedModel);
        ThymeleafTilesView.addRequestContextAsVariable(mergedModel, (String)"springRequestContext", (RequestContext)requestContext);
        ThymeleafTilesView.addRequestContextAsVariable(mergedModel, (String)"springMacroRequestContext", (RequestContext)requestContext);
        ConversionService conversionService = (ConversionService)request.getAttribute(ConversionService.class.getName());
        ThymeleafEvaluationContext evaluationContext = new ThymeleafEvaluationContext((BeanFactory)applicationContext, conversionService);
        mergedModel.put("thymeleafEvaluationContext", evaluationContext);
        SpringWebContext context = new SpringWebContext(request, response, servletContext, this.getLocale(), mergedModel, this.getApplicationContext());
        DialectAwareProcessingContext processingContext = new DialectAwareProcessingContext((IContext)context, (Collection)templateEngine.getDialects());
        String templateContentType = this.getContentType();
        Locale templateLocale = this.getLocale();
        String templateCharacterEncoding = this.getCharacterEncoding();
        response.setLocale(templateLocale);
        if (templateContentType != null) {
            response.setContentType(templateContentType);
        } else {
            response.setContentType("text/html;charset=ISO-8859-1");
        }
        if (templateCharacterEncoding != null) {
            response.setCharacterEncoding(templateCharacterEncoding);
        }
        this.exposeModelAsRequestAttributes(mergedModel, request);
        JstlUtils.exposeLocalizationContext((RequestContext)requestContext);
        return processingContext;
    }

    protected Locale getLocale() {
        return super.getLocale();
    }

    protected void setLocale(Locale locale) {
        super.setLocale(locale);
    }

    protected SpringTemplateEngine getTemplateEngine() {
        return super.getTemplateEngine();
    }

    protected void setTemplateEngine(SpringTemplateEngine templateEngine) {
        super.setTemplateEngine(templateEngine);
    }

    protected boolean isContentTypeSet() {
        return super.isContentTypeSet();
    }

    protected void exposeModelAsRequestAttributes(Map<String, ?> model, HttpServletRequest request) throws Exception {
        for (Map.Entry<String, ?> entry : model.entrySet()) {
            String modelName = entry.getKey();
            Object modelValue = entry.getValue();
            if (modelValue != null) {
                request.setAttribute(modelName, modelValue);
                continue;
            }
            request.removeAttribute(modelName);
        }
    }

    static {
        String pathVariablesSelectorValue = null;
        try {
            Field pathVariablesField = View.class.getDeclaredField("PATH_VARIABLES");
            pathVariablesSelectorValue = (String)pathVariablesField.get(null);
        }
        catch (NoSuchFieldException ignored) {
            pathVariablesSelectorValue = null;
        }
        catch (IllegalAccessException ignored) {
            pathVariablesSelectorValue = null;
        }
        pathVariablesSelector = pathVariablesSelectorValue;
    }
}

