/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.redismock;

import ai.grakn.redismock.RedisClient;
import ai.grakn.redismock.Slice;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RedisBase {
    private final Map<Slice, Set<RedisClient>> subscribers = new ConcurrentHashMap<Slice, Set<RedisClient>>();
    private final Map<Slice, Slice> base = new ConcurrentHashMap<Slice, Slice>();
    private final Map<Slice, Long> deadlines = new ConcurrentHashMap<Slice, Long>();
    private final Set<RedisBase> syncBases = ConcurrentHashMap.newKeySet();

    public void addSyncBase(RedisBase base) {
        this.syncBases.add(base);
    }

    public Set<Slice> keys() {
        return this.base.keySet();
    }

    public Slice rawGet(Slice key) {
        Preconditions.checkNotNull((Object)key);
        Long deadline = this.deadlines.get(key);
        if (deadline != null && deadline != -1L && deadline <= System.currentTimeMillis()) {
            this.base.remove(key);
            this.deadlines.remove(key);
            return null;
        }
        return this.base.get(key);
    }

    public Long getTTL(Slice key) {
        Preconditions.checkNotNull((Object)key);
        Long deadline = this.deadlines.get(key);
        if (deadline == null) {
            return null;
        }
        if (deadline == -1L) {
            return deadline;
        }
        long now = System.currentTimeMillis();
        if (now < deadline) {
            return deadline - now;
        }
        this.base.remove(key);
        this.deadlines.remove(key);
        return null;
    }

    public long setTTL(Slice key, long ttl) {
        Preconditions.checkNotNull((Object)key);
        if (this.base.containsKey(key)) {
            this.deadlines.put(key, ttl + System.currentTimeMillis());
            for (RedisBase base : this.syncBases) {
                base.setTTL(key, ttl);
            }
            return 1L;
        }
        return 0L;
    }

    public long setDeadline(Slice key, long deadline) {
        Preconditions.checkNotNull((Object)key);
        if (this.base.containsKey(key)) {
            this.deadlines.put(key, deadline);
            for (RedisBase base : this.syncBases) {
                base.setDeadline(key, deadline);
            }
            return 1L;
        }
        return 0L;
    }

    public void clear() {
        this.base.clear();
        this.subscribers.clear();
        this.deadlines.clear();
        this.syncBases.clear();
    }

    public void rawPut(Slice key, Slice value, Long ttl) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        this.base.put(key, value);
        if (ttl != null) {
            if (ttl != -1L) {
                this.deadlines.put(key, ttl + System.currentTimeMillis());
            } else {
                this.deadlines.put(key, -1L);
            }
        }
        for (RedisBase base : this.syncBases) {
            base.rawPut(key, value, ttl);
        }
    }

    public void del(Slice key) {
        Preconditions.checkNotNull((Object)key);
        this.base.remove(key);
        this.deadlines.remove(key);
        for (RedisBase base : this.syncBases) {
            base.del(key);
        }
    }

    public void addSubscriber(Slice channel, RedisClient client) {
        HashSet<RedisClient> newClient = new HashSet<RedisClient>();
        newClient.add(client);
        this.subscribers.merge(channel, newClient, (currentSubscribers, newSubscribers) -> {
            currentSubscribers.addAll(newSubscribers);
            return currentSubscribers;
        });
    }

    public boolean removeSubscriber(Slice channel, RedisClient client) {
        if (this.subscribers.containsKey(channel)) {
            this.subscribers.get(channel).remove(client);
            return true;
        }
        return false;
    }

    public Set<RedisClient> getSubscribers(Slice channel) {
        if (this.subscribers.containsKey(channel)) {
            return this.subscribers.get(channel);
        }
        return Collections.emptySet();
    }

    public List<Slice> getSubscriptions(RedisClient client) {
        ArrayList<Slice> subscriptions = new ArrayList<Slice>();
        this.subscribers.forEach((channel, subscribers) -> {
            if (subscribers.contains(client)) {
                subscriptions.add((Slice)channel);
            }
        });
        return subscriptions;
    }
}

