/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import cn.afterturn.easypoi.cache.ImageCache;
import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelCollection;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import cn.afterturn.easypoi.excel.annotation.ExcelIgnore;
import cn.afterturn.easypoi.util.PoiElUtil;
import cn.afterturn.easypoi.util.PoiReflectorUtil;
import cn.afterturn.easypoi.word.entity.params.ExcelListEntity;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoiPublicUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiPublicUtil.class);

    private PoiPublicUtil() {
    }

    public static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    public static Object createObject(Class<?> clazz, String targetId) {
        Object obj = null;
        try {
            Field[] fields;
            if (clazz.equals(Map.class)) {
                return new LinkedHashMap();
            }
            obj = clazz.newInstance();
            for (Field field : fields = PoiPublicUtil.getClassFields(clazz)) {
                if (PoiPublicUtil.isNotUserExcelUserThis(null, field, targetId)) continue;
                if (PoiPublicUtil.isCollection(field.getType())) {
                    ExcelCollection collection = field.getAnnotation(ExcelCollection.class);
                    PoiReflectorUtil.fromCache(clazz).setValue(obj, field.getName(), collection.type().newInstance());
                    continue;
                }
                if (PoiPublicUtil.isJavaClass(field) || field.getType().isEnum()) continue;
                PoiReflectorUtil.fromCache(clazz).setValue(obj, field.getName(), PoiPublicUtil.createObject(field.getType(), targetId));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u521b\u5efa\u5bf9\u8c61\u5f02\u5e38");
        }
        return obj;
    }

    public static Field[] getClassFields(Class<?> clazz) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                list.add(fields[i]);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null);
        return list.toArray(fields);
    }

    public static String getFileExtendName(byte[] photoByte) {
        String strFileExtendName = "JPG";
        if (photoByte[0] == 71 && photoByte[1] == 73 && photoByte[2] == 70 && photoByte[3] == 56 && (photoByte[4] == 55 || photoByte[4] == 57) && photoByte[5] == 97) {
            strFileExtendName = "GIF";
        } else if (photoByte[6] == 74 && photoByte[7] == 70 && photoByte[8] == 73 && photoByte[9] == 70) {
            strFileExtendName = "JPG";
        } else if (photoByte[0] == 66 && photoByte[1] == 77) {
            strFileExtendName = "BMP";
        } else if (photoByte[1] == 80 && photoByte[2] == 78 && photoByte[3] == 71) {
            strFileExtendName = "PNG";
        }
        return strFileExtendName;
    }

    public static boolean hasBom(InputStream in) throws IOException {
        byte[] head = new byte[3];
        in.read(head);
        return head[0] == -17 && head[1] == -69 && head[2] == -65;
    }

    public static Map<String, PictureData> getSheetPictrues03(HSSFSheet sheet, HSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (!pictures.isEmpty()) {
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                if (!(shape instanceof HSSFPicture)) continue;
                HSSFPicture pic = (HSSFPicture)shape;
                int pictureIndex = pic.getPictureIndex() - 1;
                HSSFPictureData picData = (HSSFPictureData)pictures.get(pictureIndex);
                String picIndex = String.valueOf(anchor.getRow1()) + "_" + String.valueOf(anchor.getCol1());
                sheetIndexPicMap.put(picIndex, (PictureData)picData);
            }
            return sheetIndexPicMap;
        }
        return sheetIndexPicMap;
    }

    public static Map<String, PictureData> getSheetPictrues07(XSSFSheet sheet, XSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                if (!(shape instanceof XSSFPicture)) continue;
                XSSFPicture pic = (XSSFPicture)shape;
                XSSFClientAnchor anchor = pic.getPreferredSize();
                CTMarker ctMarker = anchor.getFrom();
                String picIndex = ctMarker.getRow() + "_" + ctMarker.getCol();
                sheetIndexPicMap.put(picIndex, (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isJavaClass(Field field) {
        Class<?> fieldType = field.getType();
        boolean isBaseClass = false;
        if (fieldType.isArray()) {
            isBaseClass = false;
        } else if (fieldType.isPrimitive() || fieldType.getPackage() == null || "java.lang".equals(fieldType.getPackage().getName()) || "java.math".equals(fieldType.getPackage().getName()) || "java.sql".equals(fieldType.getPackage().getName()) || "java.time".equals(fieldType.getPackage().getName()) || "java.util".equals(fieldType.getPackage().getName())) {
            isBaseClass = true;
        }
        return isBaseClass;
    }

    public static boolean isNotUserExcelUserThis(List<String> exclusionsList, Field field, String targetId) {
        boolean boo = true;
        if (field.getAnnotation(ExcelIgnore.class) != null) {
            boo = true;
        } else if (boo && field.getAnnotation(ExcelCollection.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(ExcelCollection.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(ExcelCollection.class).name()))) {
            boo = false;
        } else if (boo && field.getAnnotation(Excel.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(Excel.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(Excel.class).name()))) {
            boo = false;
        } else if (boo && field.getAnnotation(ExcelEntity.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(ExcelEntity.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(ExcelEntity.class).name()))) {
            boo = false;
        }
        return boo;
    }

    private static boolean isUseInThis(String exportName, String targetId) {
        return targetId == null || "".equals(exportName) || exportName.indexOf("_") < 0 || exportName.indexOf(targetId) != -1;
    }

    private static Integer getImageType(String type) {
        if ("JPG".equalsIgnoreCase(type) || "JPEG".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("GIF".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("BMP".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("PNG".equalsIgnoreCase(type)) {
            return 6;
        }
        return 5;
    }

    public static Object[] getIsAndType(ImageEntity entity) throws Exception {
        Object[] result = new Object[2];
        result[0] = entity.getType().equals(ImageEntity.URL) ? (Object)ImageCache.getImage(entity.getUrl()) : (Object)entity.getData();
        String type = PoiPublicUtil.getFileExtendName((byte[])result[0]);
        result[1] = PoiPublicUtil.getImageType(type);
        return result;
    }

    public static Object getParamsValue(String params, Object object) throws Exception {
        if (params.indexOf(".") != -1) {
            String[] paramsArr = params.split("\\.");
            return PoiPublicUtil.getValueDoWhile(object, paramsArr, 0);
        }
        if (object instanceof Map) {
            return ((Map)object).get(params);
        }
        return PoiReflectorUtil.fromCache(object.getClass()).getValue(object, params);
    }

    public static Object getRealValue(String currentText, Map<String, Object> map) throws Exception {
        String params = "";
        while (currentText.indexOf("{{") != -1) {
            params = currentText.substring(currentText.indexOf("{{") + 2, currentText.indexOf("}}"));
            Object obj = PoiElUtil.eval(params.trim(), map);
            if (obj instanceof ImageEntity || obj instanceof List || obj instanceof ExcelListEntity) {
                return obj;
            }
            if (obj != null) {
                currentText = currentText.replace("{{" + params + "}}", obj.toString());
                continue;
            }
            currentText = currentText.replace("{{" + params + "}}", "");
        }
        return currentText;
    }

    public static Object getValueDoWhile(Object object, String[] paramsArr, int index) throws Exception {
        String params = paramsArr[index];
        boolean isGetArrayVal = false;
        int arrayIdx = -1;
        if (params.indexOf("[") > -1 && params.indexOf("]") > -1) {
            isGetArrayVal = true;
            int startIdx = params.indexOf("[");
            int endIdx = params.indexOf("]");
            String idxStr = params.substring(startIdx + 1, endIdx);
            arrayIdx = Integer.valueOf(idxStr.trim());
            params = params.substring(0, startIdx);
        }
        if (object == null) {
            return "";
        }
        if (object instanceof ImageEntity) {
            return object;
        }
        object = object instanceof Map ? ((Map)object).get(params) : PoiReflectorUtil.fromCache(object.getClass()).getValue(object, params);
        if (isGetArrayVal && null != object && object instanceof List) {
            List list = (List)object;
            object = arrayIdx < 0 || arrayIdx >= list.size() ? null : ((List)object).get(arrayIdx);
        }
        if (object instanceof Collection) {
            return object;
        }
        return index == paramsArr.length - 1 ? (object == null ? "" : object) : PoiPublicUtil.getValueDoWhile(object, paramsArr, ++index);
    }

    public static String doubleToString(Double value) {
        String temp = value.toString();
        if (temp.contains("E")) {
            BigDecimal bigDecimal = new BigDecimal(temp);
            temp = bigDecimal.toPlainString();
        }
        return temp;
    }

    public static String getValueByTargetId(String key, String targetId, String defalut) {
        String[] arr;
        if (StringUtils.isEmpty((CharSequence)targetId) || key.indexOf("_") < 0) {
            return key;
        }
        for (String str : arr = key.split(",")) {
            String[] tempArr = str.split("_");
            if (tempArr == null || tempArr.length < 2) {
                return defalut;
            }
            if (!targetId.equals(tempArr[1])) continue;
            return tempArr[0];
        }
        return defalut;
    }

    public static void setWordText(XWPFRun currentRun, String currentText) {
        if (StringUtils.isNotEmpty((CharSequence)currentText)) {
            String[] tempArr = currentText.split("\r\n");
            int le = tempArr.length - 1;
            for (int i = 0; i < le; ++i) {
                currentRun.setText(tempArr[i], i);
                currentRun.addBreak();
            }
            currentRun.setText(tempArr[tempArr.length - 1], tempArr.length - 1);
        } else {
            currentRun.setText("", 0);
        }
    }

    public static int getNumDigits(int num) {
        int count = 0;
        while (num > 0) {
            num /= 10;
            ++count;
        }
        return count;
    }

    public static String getLastFieldName(String name) {
        String[] paramsArr = name.split("\\.");
        return paramsArr[paramsArr.length - 1];
    }

    public static String getElStr(String str, String key) {
        int keyIndex = str.indexOf(key);
        int startIndex = str.substring(0, keyIndex).lastIndexOf("{{");
        int endIndex = str.indexOf("}}", keyIndex) + 2;
        return str.substring(startIndex, endIndex);
    }

    public static void copyCellAndSetValue(XWPFTableCell tmpCell, XWPFTableCell cell, String text) throws Exception {
        CTP ctp;
        CTTc cttc2 = tmpCell.getCTTc();
        CTTcPr ctPr2 = cttc2.getTcPr();
        cell.getTableRow().setHeight(tmpCell.getTableRow().getHeight());
        CTTc cttc = cell.getCTTc();
        CTTcPr ctPr = cttc.addNewTcPr();
        if (tmpCell.getColor() != null) {
            cell.setColor(tmpCell.getColor());
        }
        if (tmpCell.getVerticalAlignment() != null) {
            cell.setVerticalAlignment(tmpCell.getVerticalAlignment());
        }
        if (ctPr2.getTcW() != null) {
            ctPr.addNewTcW().setW(ctPr2.getTcW().getW());
        }
        if (ctPr2.getVAlign() != null) {
            ctPr.addNewVAlign().setVal(ctPr2.getVAlign().getVal());
        }
        if (cttc2.getPList().size() > 0 && (ctp = (CTP)cttc2.getPList().get(0)).getPPr() != null && ctp.getPPr().getJc() != null) {
            ((CTP)cttc.getPList().get(0)).addNewPPr().addNewJc().setVal(ctp.getPPr().getJc().getVal());
        }
        if (ctPr2.getTcBorders() != null) {
            ctPr.setTcBorders(ctPr2.getTcBorders());
        }
        XWPFParagraph tmpP = (XWPFParagraph)tmpCell.getParagraphs().get(0);
        XWPFParagraph cellP = (XWPFParagraph)cell.getParagraphs().get(0);
        XWPFRun tmpR = null;
        if (tmpP.getRuns() != null && tmpP.getRuns().size() > 0) {
            tmpR = (XWPFRun)tmpP.getRuns().get(0);
        }
        XWPFRun cellR = cellP.createRun();
        cellR.setText(text);
        if (tmpR != null) {
            CTRPr tmpRPr;
            cellR.setBold(tmpR.isBold());
            cellR.setItalic(tmpR.isItalic());
            cellR.setStrike(tmpR.isStrike());
            cellR.setUnderline(tmpR.getUnderline());
            cellR.setColor(tmpR.getColor());
            cellR.setTextPosition(tmpR.getTextPosition());
            if (tmpR.getFontSize() != -1) {
                cellR.setFontSize(tmpR.getFontSize());
            }
            if (tmpR.getFontFamily() != null) {
                cellR.setFontFamily(tmpR.getFontFamily());
            }
            if (tmpR.getCTR() != null && tmpR.getCTR().isSetRPr() && (tmpRPr = tmpR.getCTR().getRPr()).isSetRFonts()) {
                CTFonts tmpFonts = tmpRPr.getRFonts();
                CTRPr cellRPr = cellR.getCTR().isSetRPr() ? cellR.getCTR().getRPr() : cellR.getCTR().addNewRPr();
                CTFonts cellFonts = cellRPr.isSetRFonts() ? cellRPr.getRFonts() : cellRPr.addNewRFonts();
                cellFonts.setAscii(tmpFonts.getAscii());
                cellFonts.setAsciiTheme(tmpFonts.getAsciiTheme());
                cellFonts.setCs(tmpFonts.getCs());
                cellFonts.setCstheme(tmpFonts.getCstheme());
                cellFonts.setEastAsia(tmpFonts.getEastAsia());
                cellFonts.setEastAsiaTheme(tmpFonts.getEastAsiaTheme());
                cellFonts.setHAnsi(tmpFonts.getHAnsi());
                cellFonts.setHAnsiTheme(tmpFonts.getHAnsiTheme());
            }
        }
        if (tmpP.getAlignment() != null) {
            cellP.setAlignment(tmpP.getAlignment());
        }
        if (tmpP.getVerticalAlignment() != null) {
            cellP.setVerticalAlignment(tmpP.getVerticalAlignment());
        }
        if (tmpP.getBorderBetween() != null) {
            cellP.setBorderBetween(tmpP.getBorderBetween());
        }
        if (tmpP.getBorderBottom() != null) {
            cellP.setBorderBottom(tmpP.getBorderBottom());
        }
        if (tmpP.getBorderLeft() != null) {
            cellP.setBorderLeft(tmpP.getBorderLeft());
        }
        if (tmpP.getBorderRight() != null) {
            cellP.setBorderRight(tmpP.getBorderRight());
        }
        if (tmpP.getBorderTop() != null) {
            cellP.setBorderTop(tmpP.getBorderTop());
        }
        cellP.setPageBreak(tmpP.isPageBreak());
        if (tmpP.getCTP() != null && tmpP.getCTP().getPPr() != null) {
            CTInd tmpInd;
            CTPPr tmpPPr = tmpP.getCTP().getPPr();
            CTPPr cellPPr = cellP.getCTP().getPPr() != null ? cellP.getCTP().getPPr() : cellP.getCTP().addNewPPr();
            CTSpacing tmpSpacing = tmpPPr.getSpacing();
            if (tmpSpacing != null) {
                CTSpacing cellSpacing;
                CTSpacing cTSpacing = cellSpacing = cellPPr.getSpacing() != null ? cellPPr.getSpacing() : cellPPr.addNewSpacing();
                if (tmpSpacing.getAfter() != null) {
                    cellSpacing.setAfter(tmpSpacing.getAfter());
                }
                if (tmpSpacing.getAfterAutospacing() != null) {
                    cellSpacing.setAfterAutospacing(tmpSpacing.getAfterAutospacing());
                }
                if (tmpSpacing.getAfterLines() != null) {
                    cellSpacing.setAfterLines(tmpSpacing.getAfterLines());
                }
                if (tmpSpacing.getBefore() != null) {
                    cellSpacing.setBefore(tmpSpacing.getBefore());
                }
                if (tmpSpacing.getBeforeAutospacing() != null) {
                    cellSpacing.setBeforeAutospacing(tmpSpacing.getBeforeAutospacing());
                }
                if (tmpSpacing.getBeforeLines() != null) {
                    cellSpacing.setBeforeLines(tmpSpacing.getBeforeLines());
                }
                if (tmpSpacing.getLine() != null) {
                    cellSpacing.setLine(tmpSpacing.getLine());
                }
                if (tmpSpacing.getLineRule() != null) {
                    cellSpacing.setLineRule(tmpSpacing.getLineRule());
                }
            }
            if ((tmpInd = tmpPPr.getInd()) != null) {
                CTInd cellInd;
                CTInd cTInd = cellInd = cellPPr.getInd() != null ? cellPPr.getInd() : cellPPr.addNewInd();
                if (tmpInd.getFirstLine() != null) {
                    cellInd.setFirstLine(tmpInd.getFirstLine());
                }
                if (tmpInd.getFirstLineChars() != null) {
                    cellInd.setFirstLineChars(tmpInd.getFirstLineChars());
                }
                if (tmpInd.getHanging() != null) {
                    cellInd.setHanging(tmpInd.getHanging());
                }
                if (tmpInd.getHangingChars() != null) {
                    cellInd.setHangingChars(tmpInd.getHangingChars());
                }
                if (tmpInd.getLeft() != null) {
                    cellInd.setLeft(tmpInd.getLeft());
                }
                if (tmpInd.getLeftChars() != null) {
                    cellInd.setLeftChars(tmpInd.getLeftChars());
                }
                if (tmpInd.getRight() != null) {
                    cellInd.setRight(tmpInd.getRight());
                }
                if (tmpInd.getRightChars() != null) {
                    cellInd.setRightChars(tmpInd.getRightChars());
                }
            }
        }
    }
}

