/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.wps.service;

import cn.afterturn.easypoi.wps.entity.WpsFileEntity;
import cn.afterturn.easypoi.wps.entity.WpsToken;
import cn.afterturn.easypoi.wps.entity.resreq.WpsFileHistoryRequest;
import cn.afterturn.easypoi.wps.entity.resreq.WpsFileHistoryResponse;
import cn.afterturn.easypoi.wps.entity.resreq.WpsFileResponse;
import cn.afterturn.easypoi.wps.entity.resreq.WpsUserRequest;
import cn.afterturn.easypoi.wps.service.EasyPoiWpsFileUtil;
import cn.afterturn.easypoi.wps.service.EasyPoiWpsUtil;
import cn.afterturn.easypoi.wps.service.IEasyPoiWpsService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.web.multipart.MultipartFile;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public interface IEasyPoiWpsViewService
extends IEasyPoiWpsService {
    default public WpsToken getViewUrl(final String filePath) {
        WpsToken t = new WpsToken();
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("_w_appid", IEasyPoiWpsViewService.this.getAppId());
                this.put("_w_userid", IEasyPoiWpsViewService.this.getUserId());
                this.put("_w_filepath", filePath);
            }
        };
        String keyValueStr = EasyPoiWpsUtil.getKeyValueStr((Map<String, String>)values);
        String signature = EasyPoiWpsUtil.getSignature((Map<String, String>)values, this.getAppSecret());
        String fileTypeCode = EasyPoiWpsFileUtil.getFileTypeCode(EasyPoiWpsFileUtil.getFileTypeByPath(filePath));
        String wpsUrl = this.getDomain() + fileTypeCode + "/" + this.getFileId(filePath) + "?" + keyValueStr + "_w_signature=" + signature;
        t.setToken(this.getToken());
        t.setExpires_in(600);
        t.setWpsUrl(wpsUrl);
        return t;
    }

    default public String getToken() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    default public String getFileId(String filePath) {
        return UUID.randomUUID().toString().replace("-", "");
    }

    default public String getDomain() {
        return "https://wwo.wps.cn/office/";
    }

    default public String getUserId() {
        return "0";
    }

    default public WpsFileResponse getFileInfo(String userId, String filepath, String fileId) {
        WpsFileResponse response = new WpsFileResponse();
        WpsFileEntity fileEntity = new WpsFileEntity();
        fileEntity.setId(fileId);
        fileEntity.setName(this.getFileName(filepath));
        fileEntity.setSize(this.getFileSize(filepath));
        fileEntity.setDownload_url(this.getDownLoadUrl(filepath));
        response.setFile(fileEntity);
        return response;
    }

    public int getFileSize(String var1);

    public String getDownLoadUrl(String var1);

    default public String getFileName(String filepath) {
        return EasyPoiWpsFileUtil.getFileName(filepath);
    }

    default public void fileOnline(String fileId, WpsUserRequest list) {
    }

    default public WpsFileEntity fileSave(String fileId, String userId, MultipartFile file) {
        throw new NotImplementedException();
    }

    default public WpsFileEntity getFileInfoOfVersion(String fileId, String filepath, Integer version) {
        WpsFileEntity fileEntity = new WpsFileEntity();
        fileEntity.setId(fileId);
        fileEntity.setName(this.getFileName(filepath));
        fileEntity.setDownload_url(this.getDownLoadUrl(filepath, version));
        fileEntity.setModifier(fileEntity.getModifier());
        fileEntity.setModify_time(System.currentTimeMillis());
        return fileEntity;
    }

    default public String getDownLoadUrl(String filepath, Integer version) {
        throw new NotImplementedException();
    }

    default public void rename(String fileId, String userId, String name) {
        throw new NotImplementedException();
    }

    default public WpsFileHistoryResponse getHistory(WpsFileHistoryRequest req) {
        throw new NotImplementedException();
    }
}

