/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayMobilePublicMultiMediaDownloadRequest;
import com.alipay.api.AlipayMobilePublicMultiMediaDownloadResponse;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.internal.parser.json.ObjectJsonParser;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.internal.util.RequestParametersHolder;
import com.alipay.api.internal.util.StreamUtil;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.json.JSONWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class AlipayMobilePublicMultiMediaClient
implements AlipayClient {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";
    private String serverUrl;
    private String appId;
    private String privateKey;
    private String prodCode;
    private String format = "json";
    private String sign_type = "RSA";
    private String charset;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;

    public AlipayMobilePublicMultiMediaClient(String serverUrl, String appId, String privateKey) {
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
    }

    public AlipayMobilePublicMultiMediaClient(String serverUrl, String appId, String privateKey, String format) {
        this(serverUrl, appId, privateKey);
        this.format = format;
    }

    public AlipayMobilePublicMultiMediaClient(String serverUrl, String appId, String privateKey, String format, String charset) {
        this(serverUrl, appId, privateKey);
        this.format = format;
        this.charset = charset;
    }

    public AlipayMobilePublicMultiMediaClient(String serverUrl, String appId, String privateKey, String format, String charset, String signType) {
        this(serverUrl, appId, privateKey, format, charset);
        this.sign_type = signType;
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request) throws AlipayApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request, String accessToken) throws AlipayApiException {
        return this.execute(request, accessToken, null);
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request, String accessToken, String appAuthToken) throws AlipayApiException {
        return this._execute(request, accessToken, appAuthToken);
    }

    private <T extends AlipayResponse> T _execute(AlipayRequest<T> request, String authToken, String appAuthToken) throws AlipayApiException {
        return this.doGet(request, appAuthToken);
    }

    public <T extends AlipayResponse> T doGet(AlipayRequest<T> request, String appAuthToken) throws AlipayApiException {
        String signContent;
        if (StringUtils.isEmpty(this.charset)) {
            this.charset = DEFAULT_CHARSET;
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        AlipayHashMap appParams = new AlipayHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        try {
            if (request.getClass().getMethod("getBizContent", new Class[0]) != null && StringUtils.isEmpty((String)appParams.get("biz_content")) && request.getBizModel() != null) {
                appParams.put("biz_content", new JSONWriter().write(request.getBizModel(), true));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException e) {
            AlipayLogger.logBizError(e);
        }
        if (!StringUtils.isEmpty(appAuthToken)) {
            appParams.put("app_auth_token", appAuthToken);
        }
        requestHolder.setApplicationParams(appParams);
        AlipayHashMap protocalMustParams = new AlipayHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("version", request.getApiVersion());
        protocalMustParams.put("app_id", this.appId);
        protocalMustParams.put("sign_type", this.sign_type);
        protocalMustParams.put("charset", this.charset);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put("timestamp", df.format(new Date(timestamp)));
        protocalMustParams.put("format", this.format);
        requestHolder.setProtocalMustParams(protocalMustParams);
        if ("RSA".equals(this.sign_type)) {
            signContent = AlipaySignature.getSignatureContent(requestHolder);
            protocalMustParams.put("sign", AlipaySignature.rsaSign(signContent, this.privateKey, this.charset));
        } else if ("RSA2".equals(this.sign_type)) {
            signContent = AlipaySignature.getSignatureContent(requestHolder);
            protocalMustParams.put("sign", AlipaySignature.rsa256Sign(signContent, this.privateKey, this.charset));
        } else {
            protocalMustParams.put("sign", "");
        }
        AlipayMobilePublicMultiMediaDownloadResponse rsp = null;
        try {
            if (request instanceof AlipayMobilePublicMultiMediaDownloadRequest) {
                OutputStream outputStream = ((AlipayMobilePublicMultiMediaDownloadRequest)request).getOutputStream();
                rsp = AlipayMobilePublicMultiMediaClient.doGet(this.serverUrl, requestHolder, this.charset, this.connectTimeout, this.readTimeout, outputStream);
            }
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        return (T)rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AlipayMobilePublicMultiMediaDownloadResponse doGet(String url, RequestParametersHolder requestHolder, String charset, int connectTimeout, int readTimeout, OutputStream output) throws AlipayApiException, IOException {
        HttpURLConnection conn = null;
        AlipayMobilePublicMultiMediaDownloadResponse response = null;
        try {
            AlipayHashMap protocalOptParams;
            AlipayHashMap protocalMustParams;
            TreeMap<String, String> params = new TreeMap<String, String>();
            AlipayHashMap appParams = requestHolder.getApplicationParams();
            if (appParams != null && appParams.size() > 0) {
                params.putAll(appParams);
            }
            if ((protocalMustParams = requestHolder.getProtocalMustParams()) != null && protocalMustParams.size() > 0) {
                params.putAll(protocalMustParams);
            }
            if ((protocalOptParams = requestHolder.getProtocalOptParams()) != null && protocalOptParams.size() > 0) {
                params.putAll(protocalOptParams);
            }
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = AlipayMobilePublicMultiMediaClient.buildQuery(params, charset);
            try {
                conn = AlipayMobilePublicMultiMediaClient.getConnection(AlipayMobilePublicMultiMediaClient.buildGetUrl(url, query), METHOD_GET, ctype);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
            }
            catch (IOException e) {
                Map<String, String> map = AlipayMobilePublicMultiMediaClient.getParamsFromUrl(url);
                AlipayLogger.logCommError((Exception)e, url, map.get("app_key"), map.get("method"), params);
                throw e;
            }
            try {
                if (conn.getResponseCode() == 200) {
                    if (conn.getContentType() != null && conn.getContentType().toLowerCase().contains("text/plain")) {
                        String rsp = AlipayMobilePublicMultiMediaClient.getResponseAsString(conn);
                        ObjectJsonParser<AlipayMobilePublicMultiMediaDownloadResponse> parser = new ObjectJsonParser<AlipayMobilePublicMultiMediaDownloadResponse>(AlipayMobilePublicMultiMediaDownloadResponse.class);
                        response = parser.parse(rsp);
                        response.setBody(rsp);
                        response.setParams(appParams);
                        AlipayMobilePublicMultiMediaDownloadResponse alipayMobilePublicMultiMediaDownloadResponse = response;
                        return alipayMobilePublicMultiMediaDownloadResponse;
                    }
                    StreamUtil.io(conn.getInputStream(), output);
                    response = new AlipayMobilePublicMultiMediaDownloadResponse();
                    response.setCode("200");
                    response.setMsg("\u6210\u529f");
                    response.setBody("{\"alipay_mobile_public_multimedia_download_response\":{\"code\":200,\"msg\":\"\u6210\u529f\"}}");
                    response.setParams(appParams);
                    return response;
                }
                response = new AlipayMobilePublicMultiMediaDownloadResponse();
                response.setCode(String.valueOf(conn.getResponseCode()));
                response.setMsg(conn.getResponseMessage());
                response.setParams(appParams);
                return response;
            }
            catch (IOException e) {
                Map<String, String> map = AlipayMobilePublicMultiMediaClient.getParamsFromUrl(url);
                AlipayLogger.logCommError((Exception)e, conn, map.get("app_key"), map.get("method"), params);
                throw e;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return false;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("User-Agent", "aop-sdk-java");
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = AlipayMobilePublicMultiMediaClient.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return AlipayMobilePublicMultiMediaClient.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = AlipayMobilePublicMultiMediaClient.getStreamAsString(es, charset);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    private static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = AlipayMobilePublicMultiMediaClient.splitUrlQuery(url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty(query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    @Override
    public <T extends AlipayResponse> T pageExecute(AlipayRequest<T> request) throws AlipayApiException {
        return null;
    }

    @Override
    public <T extends AlipayResponse> T pageExecute(AlipayRequest<T> request, String method) throws AlipayApiException {
        return null;
    }

    @Override
    public <TR extends AlipayResponse, T extends AlipayRequest<TR>> TR parseAppSyncResult(Map<String, String> result, Class<T> requsetClazz) throws AlipayApiException {
        return null;
    }

    @Override
    public <T extends AlipayResponse> T sdkExecute(AlipayRequest<T> request) throws AlipayApiException {
        return null;
    }

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

