/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.CopiedIterator;
import cn.hutool.core.collection.EnumerationIterator;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IterUtil {
    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || IterUtil.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return null == Iterator2 || false == Iterator2.hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && IterUtil.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return null != Iterator2 && Iterator2.hasNext();
    }

    public static boolean hasNull(Iterable<?> iter) {
        return IterUtil.hasNull(null == iter ? null : iter.iterator());
    }

    public static boolean hasNull(Iterator<?> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (null != iter.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Iterable<?> iter) {
        return IterUtil.isAllNull(null == iter ? null : iter.iterator());
    }

    public static boolean isAllNull(Iterator<?> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (null == iter.next()) continue;
            return false;
        }
        return true;
    }

    public static <T> Map<T, Integer> countMap(Iterable<T> iter) {
        return IterUtil.countMap(null == iter ? null : iter.iterator());
    }

    public static <T> Map<T, Integer> countMap(Iterator<T> iter) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        if (null != iter) {
            while (iter.hasNext()) {
                T t = iter.next();
                Integer count = (Integer)countMap.get(t);
                if (null == count) {
                    countMap.put(t, 1);
                    continue;
                }
                countMap.put(t, count + 1);
            }
        }
        return countMap;
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterable<V> iter, String fieldName) {
        return IterUtil.fieldValueMap(null == iter ? null : iter.iterator(), fieldName);
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterator<V> iter, String fieldName) {
        HashMap<Object, V> result = new HashMap<Object, V>();
        if (null != iter) {
            while (iter.hasNext()) {
                V value = iter.next();
                result.put(ReflectUtil.getFieldValue(value, fieldName), value);
            }
        }
        return result;
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.join(iterable.iterator(), conjunction);
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        if (null == iterator) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            T item = iterator.next();
            if (ArrayUtil.isArray(item)) {
                sb.append(ArrayUtil.join(ArrayUtil.wrap(item), conjunction));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(IterUtil.join((Iterable)item, conjunction));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(IterUtil.join((Iterator)item, conjunction));
                continue;
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (IterUtil.isNotEmpty(entryIter)) {
            for (Map.Entry<K, V> entry : entryIter) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values) {
        return IterUtil.toMap(null == keys ? null : keys.iterator(), null == values ? null : values.iterator());
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values) {
        HashMap<K, Object> resultMap = new HashMap<K, Object>();
        if (IterUtil.isNotEmpty(keys)) {
            while (keys.hasNext()) {
                resultMap.put(keys.next(), null != values && values.hasNext() ? (Object)values.next() : null);
            }
        }
        return resultMap;
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return new EnumerationIterator<E>(e);
    }

    public static <E> Iterable<E> asIterable(final Iterator<E> iter) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return iter;
            }
        };
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (null != iterable) {
            return IterUtil.getFirst(iterable.iterator());
        }
        return null;
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        if (null != iterator && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        if (null != iterable) {
            Iterator<?> iterator = iterable.iterator();
            return IterUtil.getElementType(iterator);
        }
        return null;
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        CopiedIterator iter2 = new CopiedIterator(iterator);
        if (null != iter2) {
            while (iter2.hasNext()) {
                Object t = iter2.next();
                if (null == t) continue;
                return t.getClass();
            }
        }
        return null;
    }
}

