/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.caller;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.caller.Caller;

public class StackTraceCaller
implements Caller {
    private static final int OFFSET = 2;

    @Override
    public Class<?> getCaller() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (null == stackTrace || 3 >= stackTrace.length) {
            return null;
        }
        String className = stackTrace[3].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e, "[{}] not found!", className);
        }
    }

    @Override
    public Class<?> getCallerCaller() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (null == stackTrace || 4 >= stackTrace.length) {
            return null;
        }
        String className = stackTrace[4].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e, "[{}] not found!", className);
        }
    }

    @Override
    public Class<?> getCaller(int depth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (null == stackTrace || 2 + depth >= stackTrace.length) {
            return null;
        }
        String className = stackTrace[2 + depth].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e, "[{}] not found!", className);
        }
    }

    @Override
    public boolean isCalledBy(Class<?> clazz) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (null != stackTrace) {
            for (StackTraceElement element : stackTrace) {
                if (!element.getClassName().equals(clazz.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

