/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.console;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import java.util.Map;

public class ConsoleLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static String logFormat = "[{date}] [{level}] {name}: {msg}";
    private static Level level = Level.DEBUG;
    private String name;

    public ConsoleLog(Class<?> clazz) {
        this.name = clazz.getName();
    }

    public ConsoleLog(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return level.compareTo(Level.TRACE) <= 0;
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.log(Level.TRACE, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.log(Level.TRACE, t, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return level.compareTo(Level.DEBUG) <= 0;
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log(Level.DEBUG, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.log(Level.DEBUG, t, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return level.compareTo(Level.INFO) <= 0;
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log(Level.INFO, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.log(Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return level.compareTo(Level.WARN) <= 0;
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log(Level.WARN, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.log(Level.WARN, t, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return level.compareTo(Level.ERROR) <= 0;
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.log(Level.ERROR, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.log(Level.ERROR, t, format, arguments);
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        Dict dict = Dict.create().set("date", (Object)DateUtil.now()).set("level", (Object)level.toString()).set("name", (Object)this.name).set("msg", (Object)StrUtil.format((CharSequence)format, (Object[])arguments));
        String logMsg = StrUtil.format((CharSequence)logFormat, (Map)dict);
        if (level.ordinal() >= Level.WARN.ordinal()) {
            Console.error((Throwable)t, (String)logMsg, (Object[])new Object[0]);
        } else {
            Console.log((Throwable)t, (String)logMsg, (Object[])new Object[0]);
        }
    }
}

