/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.CellEditor;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.InternalExcelUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReader
implements Closeable {
    private boolean isClosed;
    private Workbook workbook;
    private Sheet sheet;
    private boolean ignoreEmptyRow = true;
    private CellEditor cellEditor;
    private Map<String, String> headerAlias = new HashMap<String, String>();

    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(ExcelUtil.loadBook(excelFilePath), sheetIndex);
    }

    public ExcelReader(File bookFile, int sheetIndex) {
        this(ExcelUtil.loadBook(bookFile), sheetIndex);
    }

    public ExcelReader(File bookFile, String sheetName) {
        this(ExcelUtil.loadBook(bookFile), sheetName);
    }

    public ExcelReader(InputStream bookStream, int sheetIndex) {
        this(ExcelUtil.loadBook(bookStream), sheetIndex);
    }

    public ExcelReader(InputStream bookStream, String sheetName) {
        this(ExcelUtil.loadBook(bookStream), sheetName);
    }

    public ExcelReader(Workbook book, int sheetIndex) {
        this(book.getSheetAt(sheetIndex));
    }

    public ExcelReader(Workbook book, String sheetName) {
        this(book.getSheet(sheetName));
        this.workbook = book;
    }

    public ExcelReader(Sheet sheet) {
        Assert.notNull((Object)sheet, (String)"No Sheet provided.", (Object[])new Object[0]);
        this.sheet = sheet;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public boolean isIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    public ExcelReader setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
        return this;
    }

    public ExcelReader setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        return this;
    }

    public Map<String, String> getHeaderAlias() {
        return this.headerAlias;
    }

    public ExcelReader setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelReader addHeaderAlias(String header, String alias) {
        this.headerAlias.put(header, alias);
        return this;
    }

    public ExcelReader removeHeaderAlias(String header) {
        this.headerAlias.remove(header);
        return this;
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    public List<List<Object>> read(int startRowIndex) {
        return this.read(startRowIndex, Integer.MAX_VALUE);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelReader has been closed!", (Object[])new Object[0]);
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList = this.readRow(this.sheet.getRow(i));
            if (!CollUtil.isNotEmpty(rowList) && this.ignoreEmptyRow) continue;
            if (null == rowList) {
                rowList = new ArrayList<Object>(0);
            }
            resultList.add(rowList);
        }
        return resultList;
    }

    public List<Map<String, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    public List<Map<String, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelReader has been closed!", (Object[])new Object[0]);
        int firstRowNum = this.sheet.getFirstRowNum();
        int lastRowNum = this.sheet.getLastRowNum();
        if (headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is lower than first row index {}.", (Object[])new Object[]{headerRowIndex, firstRowNum}));
        }
        if (headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is greater than last row index {}.", (Object[])new Object[]{headerRowIndex, firstRowNum}));
        }
        startRowIndex = Math.max(startRowIndex, firstRowNum);
        endRowIndex = Math.min(endRowIndex, lastRowNum);
        List<Object> headerList = this.readRow(this.sheet.getRow(headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == headerRowIndex || !CollUtil.isNotEmpty(rowList = this.readRow(this.sheet.getRow(i))) && this.ignoreEmptyRow) continue;
            if (null == rowList) {
                rowList = new ArrayList<Object>(0);
            }
            result.add(IterUtil.toMap(this.aliasHeader(headerList), rowList));
        }
        return result;
    }

    public <T> List<T> readAll(Class<T> beanType) {
        return this.read(0, 1, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelReader has been closed!", (Object[])new Object[0]);
        List<Map<String, Object>> mapList = this.read(headerRowIndex, startRowIndex, endRowIndex);
        if (Map.class.isAssignableFrom(beanType)) {
            return mapList;
        }
        ArrayList<Object> beanList = new ArrayList<Object>(mapList.size());
        for (Map<String, Object> map : mapList) {
            beanList.add(BeanUtil.mapToBean(map, beanType, (boolean)false));
        }
        return beanList;
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.workbook);
        this.sheet = null;
        this.workbook = null;
        this.isClosed = true;
    }

    private List<Object> readRow(Row row) {
        return InternalExcelUtil.readRow(row, this.cellEditor);
    }

    private List<String> aliasHeader(List<Object> headerList) {
        ArrayList<String> result = new ArrayList<String>();
        String alias = null;
        for (Object headerObj : headerList) {
            String header;
            if (null != headerObj && null == (alias = this.headerAlias.get(header = headerObj.toString()))) {
                alias = header;
            }
            result.add(alias);
        }
        return result;
    }
}

