/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelWriter;
import cn.hutool.poi.excel.sax.Excel03SaxReader;
import cn.hutool.poi.excel.sax.Excel07SaxReader;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import cn.hutool.poi.exceptions.POIException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    public static void readBySax(String path, int sheetIndex, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.getInputStream((String)path), sheetIndex, rowHandler);
    }

    public static void readBySax(File file, int sheetIndex, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.getInputStream((File)file), sheetIndex, rowHandler);
    }

    public static void readBySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        if (ExcelUtil.isXlsx(in)) {
            ExcelUtil.read07BySax(in, sheetIndex, rowHandler);
        } else {
            ExcelUtil.read03BySax(in, sheetIndex, rowHandler);
        }
    }

    public static Excel07SaxReader read07BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        return new Excel07SaxReader(rowHandler).read(in, sheetIndex);
    }

    public static Excel07SaxReader read07BySax(File file, int sheetIndex, RowHandler rowHandler) {
        return new Excel07SaxReader(rowHandler).read(file, sheetIndex);
    }

    public static Excel07SaxReader read07BySax(String path, int sheetIndex, RowHandler rowHandler) {
        return (Excel07SaxReader)new Excel07SaxReader(rowHandler).read(path, sheetIndex);
    }

    public static Excel03SaxReader read03BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        return new Excel03SaxReader(rowHandler).read(in, sheetIndex);
    }

    public static Excel03SaxReader read03BySax(File file, int sheetIndex, RowHandler rowHandler) {
        return new Excel03SaxReader(rowHandler).read(file, sheetIndex);
    }

    public static Excel03SaxReader read03BySax(String path, int sheetIndex, RowHandler rowHandler) {
        return (Excel03SaxReader)new Excel03SaxReader(rowHandler).read(path, sheetIndex);
    }

    public static ExcelReader getReader(String bookFilePath) {
        return ExcelUtil.getReader(bookFilePath, 0);
    }

    public static ExcelReader getReader(File bookFile) {
        return ExcelUtil.getReader(bookFile, 0);
    }

    public static ExcelReader getReader(String bookFilePath, int sheetIndex) {
        return new ExcelReader(bookFilePath, sheetIndex);
    }

    public static ExcelReader getReader(File bookFile, int sheetIndex) {
        return new ExcelReader(bookFile, sheetIndex);
    }

    public static ExcelReader getReader(File bookFile, String sheetName) {
        return new ExcelReader(bookFile, sheetName);
    }

    public static ExcelReader getReader(InputStream bookStream) {
        return ExcelUtil.getReader(bookStream, 0);
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex) {
        return new ExcelReader(bookStream, sheetIndex);
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName) {
        return new ExcelReader(bookStream, sheetName);
    }

    public static Workbook loadBook(String excelFilePath) {
        return ExcelUtil.loadBook(FileUtil.file((String)excelFilePath), null);
    }

    public static Workbook loadBook(File excelFile) {
        return ExcelUtil.loadBook(excelFile, null);
    }

    public static Workbook loadBook(File excelFile, String password) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static Workbook loadBook(InputStream in) {
        try {
            return WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static Workbook createBook(String destFilePath) {
        Object workbook = StrUtil.endWithIgnoreCase((CharSequence)destFilePath, (CharSequence)"xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static Workbook createBook(File destFile) {
        return ExcelUtil.createBook(destFile.getName());
    }

    public static void writeBook(Workbook book, OutputStream out) throws IORuntimeException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static ExcelWriter getWriter() {
        return new ExcelWriter();
    }

    public static ExcelWriter getWriter(boolean isXlsx) {
        return new ExcelWriter(isXlsx);
    }

    public static ExcelWriter getWriter(String destFilePath) {
        return new ExcelWriter(destFilePath);
    }

    public static ExcelWriter getWriter(File destFile) {
        return new ExcelWriter(destFile);
    }

    public static ExcelWriter getWriter(String destFilePath, String sheetName) {
        return new ExcelWriter(destFilePath, sheetName);
    }

    public static ExcelWriter getWriter(File destFile, String sheetName) {
        return new ExcelWriter(destFile, sheetName);
    }

    public static boolean isXls(InputStream in) {
        PushbackInputStream pin = IoUtil.toPushbackStream((InputStream)in, (int)8);
        try {
            return FileMagic.valueOf((InputStream)pin) == FileMagic.OLE2;
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static boolean isXlsx(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        try {
            return FileMagic.valueOf((InputStream)in) == FileMagic.OOXML;
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }
}

