/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.CellEditor;
import cn.hutool.poi.excel.StyleSet;
import cn.hutool.poi.excel.editors.TrimEditor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class InternalExcelUtil {
    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        return InternalExcelUtil.getCellValue(cell, cell.getCellTypeEnum(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        if (null == cell) {
            return null;
        }
        return InternalExcelUtil.getCellValue(cell, cell.getCellTypeEnum(), cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return InternalExcelUtil.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        Object value;
        if (null == cell) {
            return null;
        }
        if (null == cellType) {
            cellType = cell.getCellTypeEnum();
        }
        switch (cellType) {
            case NUMERIC: {
                value = InternalExcelUtil.getNumericValue(cell);
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = InternalExcelUtil.getCellValue(cell, cell.getCachedFormulaResultTypeEnum(), cellEditor);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }

    public static void setCellValue(Cell cell, Object value, StyleSet styleSet) {
        if (null != styleSet.cellStyle) {
            cell.setCellStyle(styleSet.cellStyle);
        }
        if (null == value) {
            cell.setCellValue("");
        } else if (value instanceof Date) {
            if (null != styleSet && null != styleSet.cellStyleForDate) {
                cell.setCellStyle(styleSet.cellStyleForDate);
            }
            cell.setCellValue((Date)value);
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Number) {
            if ((value instanceof Double || value instanceof Float) && null != styleSet && null != styleSet.cellStyleForNumber) {
                cell.setCellStyle(styleSet.cellStyleForNumber);
            }
            cell.setCellValue(((Number)value).doubleValue());
        } else {
            cell.setCellValue(value.toString());
        }
    }

    public static List<Object> readRow(Row row, CellEditor cellEditor) {
        if (null == row) {
            return new ArrayList<Object>(0);
        }
        short length = row.getLastCellNum();
        if (length < 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> cellValues = new ArrayList<Object>(length);
        boolean isAllNull = true;
        for (short i = 0; i < length; i = (short)(i + 1)) {
            Object cellValue = InternalExcelUtil.getCellValue(row.getCell((int)i), cellEditor);
            isAllNull &= StrUtil.isEmptyIfStr((Object)cellValue);
            cellValues.add(cellValue);
        }
        if (isAllNull) {
            return new ArrayList<Object>(0);
        }
        return cellValues;
    }

    public static void writeRow(Row row, Iterable<?> rowData, StyleSet styleSet) {
        int i = 0;
        for (Object value : rowData) {
            Cell cell = row.createCell(i);
            InternalExcelUtil.setCellValue(cell, value, styleSet);
            ++i;
        }
    }

    public static Map<String, PictureData> getPicMap(Workbook workbook, int sheetIndex) {
        Assert.notNull((Object)workbook, (String)"Workbook must be not null !", (Object[])new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        if (workbook instanceof HSSFWorkbook) {
            return InternalExcelUtil.getPicMapXls((HSSFWorkbook)workbook, sheetIndex);
        }
        if (workbook instanceof XSSFWorkbook) {
            return InternalExcelUtil.getPicMapXlsx((XSSFWorkbook)workbook, sheetIndex);
        }
        throw new IllegalArgumentException(StrUtil.format((CharSequence)"Workbook type [{}] is not supported!", (Object[])new Object[]{workbook.getClass()}));
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (row < ca.getFirstRow() || row > ca.getLastRow() || column < ca.getFirstColumn() || column > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn, CellStyle cellStyle) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        if (null != cellStyle) {
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTopEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRightEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottomEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeftEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
        }
        return sheet.addMergedRegion(cellRangeAddress);
    }

    private static Map<String, PictureData> getPicMapXls(HSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> picMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (CollectionUtil.isNotEmpty((Collection)pictures)) {
            HSSFSheet sheet = workbook.getSheetAt(sheetIndex);
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                if (!(shape instanceof HSSFPicture)) continue;
                int pictureIndex = ((HSSFPicture)shape).getPictureIndex() - 1;
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                picMap.put(StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{anchor.getRow1(), anchor.getCol1()}), (PictureData)pictures.get(pictureIndex));
            }
        }
        return picMap;
    }

    private static Map<String, PictureData> getPicMapXlsx(XSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture pic = (XSSFPicture)shape;
                CTMarker ctMarker = pic.getPreferredSize().getFrom();
                sheetIndexPicMap.put(StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{ctMarker.getRow(), ctMarker.getCol()}), (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }

    private static Object getNumericValue(Cell cell) {
        long longPart;
        String format;
        double value = cell.getNumericCellValue();
        CellStyle style = cell.getCellStyle();
        if (null == style) {
            return value;
        }
        short formatIndex = style.getDataFormat();
        if (InternalExcelUtil.isDateType(formatIndex, format = style.getDataFormatString())) {
            return DateUtil.date((Date)cell.getDateCellValue());
        }
        if (null != format && format.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
            return longPart;
        }
        return value;
    }

    private static boolean isDateType(int formatIndex, String format) {
        if (formatIndex == 14 || formatIndex == 31 || formatIndex == 57 || formatIndex == 58 || formatIndex == 20 || formatIndex == 32) {
            return true;
        }
        return org.apache.poi.ss.usermodel.DateUtil.isADateFormat((int)formatIndex, (String)format);
    }
}

