/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.config.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.config.api.ConfigInitCallbackApi;
import cn.stylefeng.roses.kernel.config.api.ConfigInitStrategyApi;
import cn.stylefeng.roses.kernel.config.api.context.ConfigContext;
import cn.stylefeng.roses.kernel.config.api.exception.ConfigException;
import cn.stylefeng.roses.kernel.config.api.exception.enums.ConfigExceptionEnum;
import cn.stylefeng.roses.kernel.config.api.pojo.ConfigInitRequest;
import cn.stylefeng.roses.kernel.config.modular.entity.SysConfig;
import cn.stylefeng.roses.kernel.config.modular.mapper.SysConfigMapper;
import cn.stylefeng.roses.kernel.config.modular.pojo.InitConfigGroup;
import cn.stylefeng.roses.kernel.config.modular.pojo.InitConfigResponse;
import cn.stylefeng.roses.kernel.config.modular.pojo.param.SysConfigParam;
import cn.stylefeng.roses.kernel.config.modular.service.SysConfigService;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.callback.ConfigUpdateCallback;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysConfigServiceImpl
extends ServiceImpl<SysConfigMapper, SysConfig>
implements SysConfigService {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = new SysConfig();
        BeanUtil.copyProperties((Object)((Object)sysConfigParam), (Object)((Object)sysConfig), (String[])new String[0]);
        sysConfig.setStatusFlag(StatusEnum.ENABLE.getCode());
        this.save((Object)sysConfig);
        ConfigContext.me().putConfig(sysConfigParam.getConfigCode(), (Object)sysConfigParam.getConfigValue());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = this.querySysConfig(sysConfigParam);
        if (sysConfig == null) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_NOT_EXIST, new Object[]{"id: " + sysConfigParam.getConfigId()});
        }
        if (YesOrNotEnum.Y.getCode().equals(sysConfig.getSysFlag())) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_SYS_CAN_NOT_DELETE);
        }
        this.removeById(sysConfig.getConfigId());
        ConfigContext.me().deleteConfig(sysConfigParam.getConfigCode());
    }

    @Override
    public void delByConfigCode(String configGroupCode) {
        if (ObjectUtil.isEmpty((Object)configGroupCode)) {
            return;
        }
        LambdaUpdateWrapper sysConfigLambdaUpdateWrapper = new LambdaUpdateWrapper();
        sysConfigLambdaUpdateWrapper.eq(SysConfig::getGroupCode, (Object)configGroupCode);
        this.remove((Wrapper)sysConfigLambdaUpdateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = this.querySysConfig(sysConfigParam);
        BeanUtil.copyProperties((Object)((Object)sysConfigParam), (Object)((Object)sysConfig), (String[])new String[0]);
        sysConfig.setStatusFlag(null);
        sysConfig.setGroupCode(null);
        sysConfig.setConfigCode(null);
        this.updateById((Object)sysConfig);
        ConfigContext.me().putConfig(sysConfigParam.getConfigCode(), (Object)sysConfigParam.getConfigValue());
        try {
            Map beansOfType = SpringUtil.getBeansOfType(ConfigUpdateCallback.class);
            for (ConfigUpdateCallback value : beansOfType.values()) {
                value.configUpdate(sysConfig.getConfigCode(), sysConfig.getConfigValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SysConfig detail(SysConfigParam sysConfigParam) {
        return this.querySysConfig(sysConfigParam);
    }

    @Override
    public PageResult<SysConfig> findPage(SysConfigParam sysConfigParam) {
        LambdaQueryWrapper<SysConfig> wrapper = this.createWrapper(sysConfigParam);
        wrapper.select(new SFunction[]{SysConfig::getConfigId, SysConfig::getConfigName, SysConfig::getConfigCode, SysConfig::getConfigValue, SysConfig::getSysFlag});
        Page page2 = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page2);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initConfig(ConfigInitRequest configInitRequest) {
        if (configInitRequest == null || configInitRequest.getSysConfigs() == null) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_INIT_ERROR);
        }
        Boolean alreadyInit = this.getInitConfigFlag();
        if (alreadyInit.booleanValue()) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_INIT_ALREADY);
        }
        Map beans = SpringUtil.getBeansOfType(ConfigInitCallbackApi.class);
        if (ObjectUtil.isNotNull((Object)beans)) {
            for (ConfigInitCallbackApi initCallbackApi : beans.values()) {
                initCallbackApi.initBefore();
            }
        }
        Map sysConfigs = configInitRequest.getSysConfigs();
        sysConfigs.put("SYS_CONFIG_INIT_FLAG", "true");
        for (Map.Entry entry : sysConfigs.entrySet()) {
            String configCode = (String)entry.getKey();
            String configValue = (String)entry.getValue();
            LambdaUpdateWrapper sysConfigLambdaUpdateWrapper = new LambdaUpdateWrapper();
            sysConfigLambdaUpdateWrapper.eq(SysConfig::getConfigCode, (Object)configCode);
            sysConfigLambdaUpdateWrapper.set(SysConfig::getConfigValue, (Object)configValue);
            this.update((Wrapper)sysConfigLambdaUpdateWrapper);
            ConfigContext.me().putConfig(configCode, (Object)configValue);
        }
        if (ObjectUtil.isNotNull((Object)beans)) {
            for (ConfigInitCallbackApi initCallbackApi : beans.values()) {
                initCallbackApi.initAfter();
            }
        }
    }

    public Boolean getInitConfigFlag() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysConfig::getConfigCode, (Object)"SYS_CONFIG_INIT_FLAG");
        wrapper.select(new SFunction[]{SysConfig::getConfigValue});
        SysConfig sysConfig = (SysConfig)((Object)this.getOne((Wrapper)wrapper, false));
        if (sysConfig == null) {
            return true;
        }
        String configValue = sysConfig.getConfigValue();
        if (StrUtil.isEmpty((CharSequence)configValue)) {
            return true;
        }
        return Convert.toBool((Object)sysConfig.getConfigValue());
    }

    @Override
    public InitConfigResponse getInitConfigs() {
        InitConfigResponse initConfigResponse = new InitConfigResponse();
        initConfigResponse.setTitle("\u9996\u6b21\u8fd0\u884c\u53c2\u6570\u751f\u6210");
        initConfigResponse.setDescription("\u7b2c\u4e00\u6b21\u8fdb\u5165Guns\u7cfb\u7edf\u4f1a\u914d\u7f6e\u7cfb\u7edf\u7684\u4e00\u4e9b\u79d8\u94a5\u548c\u90e8\u7f72\u7684url\u4fe1\u606f\uff0c\u8fd9\u4e9b\u79d8\u94a5\u5747\u4e3a\u968f\u673a\u751f\u6210\uff0c\u4ee5\u786e\u4fdd\u7cfb\u7edf\u7684\u5b89\u5168\u6027");
        ArrayList<InitConfigGroup> configGroupList = new ArrayList<InitConfigGroup>();
        Map beans = SpringUtil.getBeansOfType(ConfigInitStrategyApi.class);
        for (ConfigInitStrategyApi value : beans.values()) {
            String title = value.getTitle();
            String description = value.getDescription();
            List initConfigs = value.getInitConfigs();
            configGroupList.add(new InitConfigGroup(title, description, initConfigs));
        }
        initConfigResponse.setInitConfigGroupList(configGroupList);
        return initConfigResponse;
    }

    @Override
    public void updateSysConfigTypeCode(String originTypeCode, String destTypeCode) {
        LambdaUpdateWrapper sysConfigLambdaUpdateWrapper = new LambdaUpdateWrapper();
        sysConfigLambdaUpdateWrapper.eq(SysConfig::getGroupCode, (Object)originTypeCode);
        sysConfigLambdaUpdateWrapper.set(SysConfig::getGroupCode, (Object)destTypeCode);
        this.update((Wrapper)sysConfigLambdaUpdateWrapper);
    }

    public SysConfig querySysConfig(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = (SysConfig)((Object)this.getById(sysConfigParam.getConfigId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysConfig)) || sysConfig.getDelFlag().equals(YesOrNotEnum.Y.getCode())) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_NOT_EXIST, new Object[]{"id: " + sysConfigParam.getConfigId()});
        }
        return sysConfig;
    }

    private LambdaQueryWrapper<SysConfig> createWrapper(SysConfigParam sysConfigParam) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = sysConfigParam.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(SysConfig::getConfigName, (Object)searchText)).or()).like(SysConfig::getConfigCode, (Object)searchText)).or()).like(SysConfig::getConfigValue, (Object)searchText)).or()).like(SysConfig::getRemark, (Object)searchText));
        }
        String groupCode = sysConfigParam.getGroupCode();
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)groupCode), SysConfig::getGroupCode, (Object)groupCode);
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        return queryWrapper;
    }

    @Override
    public void batchDelete(SysConfigParam sysConfigParam) {
        for (Long configId : sysConfigParam.getConfigIdList()) {
            SysConfig sysConfig = (SysConfig)((Object)this.getById(configId));
            if (ObjectUtil.isEmpty((Object)((Object)sysConfig)) || sysConfig.getDelFlag().equals(YesOrNotEnum.Y.getCode())) {
                throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_NOT_EXIST, new Object[]{"id: " + sysConfigParam.getConfigId()});
            }
            if (YesOrNotEnum.Y.getCode().equals(sysConfig.getSysFlag())) {
                throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_SYS_CAN_NOT_DELETE);
            }
            this.removeById(configId);
            ConfigContext.me().deleteConfig(sysConfig.getConfigCode());
        }
    }

    public void updateConfigByCode(String code, String value) {
        LambdaUpdateWrapper sysConfigLambdaUpdateWrapper = new LambdaUpdateWrapper();
        sysConfigLambdaUpdateWrapper.eq(SysConfig::getConfigCode, (Object)code);
        sysConfigLambdaUpdateWrapper.set(SysConfig::getConfigValue, (Object)value);
        this.update((Wrapper)sysConfigLambdaUpdateWrapper);
        ConfigContext.me().putConfig(code, (Object)value);
    }
}

