/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.mp.datascope.aop;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.db.mp.datascope.UserRoleDataScopeApi;
import cn.stylefeng.roses.kernel.db.mp.datascope.annotations.DataScope;
import cn.stylefeng.roses.kernel.db.mp.datascope.config.DataScopeConfig;
import cn.stylefeng.roses.kernel.db.mp.datascope.holder.DataScopeHolder;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Aspect
public class DataScopeAop
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(DataScopeAop.class);

    @Pointcut(value="@annotation(cn.stylefeng.roses.kernel.db.mp.datascope.annotations.DataScope)")
    private void cutService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="cutService()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        String orgIdFieldName;
        Signature signature = point.getSignature();
        MethodSignature methodSignature = null;
        if (!(signature instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        methodSignature = (MethodSignature)signature;
        Object target = point.getTarget();
        Method currentMethod = target.getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        DataScope datasource = currentMethod.getAnnotation(DataScope.class);
        UserRoleDataScopeApi userRoleDataScopeApi = null;
        try {
            userRoleDataScopeApi = (UserRoleDataScopeApi)SpringUtil.getBean(UserRoleDataScopeApi.class);
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u627e\u5230\u7528\u6237\u6743\u9650\u83b7\u53d6\u7684\u7c7b\uff01", (Throwable)e);
            return point.proceed();
        }
        DataScopeConfig userRoleDataScopeConfig = userRoleDataScopeApi.getUserRoleDataScopeConfig();
        if (userRoleDataScopeConfig == null) {
            return point.proceed();
        }
        String userIdFieldName = datasource.userIdFieldName();
        if (StrUtil.isNotBlank((CharSequence)userIdFieldName)) {
            userRoleDataScopeConfig.setUserIdFieldName(userIdFieldName);
        }
        if (StrUtil.isNotBlank((CharSequence)(orgIdFieldName = datasource.orgIdFieldName()))) {
            userRoleDataScopeConfig.setOrgIdFieldName(orgIdFieldName);
        }
        try {
            DataScopeHolder.set(userRoleDataScopeConfig);
            Object object = point.proceed();
            return object;
        }
        finally {
            DataScopeHolder.remove();
        }
    }

    public int getOrder() {
        return 100;
    }
}

