/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.requestapi.aop;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.log.api.constants.LogFileConstants;
import cn.stylefeng.roses.kernel.log.api.expander.LogConfigExpander;
import cn.stylefeng.roses.kernel.log.api.factory.LogRecordFactory;
import cn.stylefeng.roses.kernel.log.api.factory.appender.AuthedLogAppender;
import cn.stylefeng.roses.kernel.log.api.factory.appender.HttpLogAppender;
import cn.stylefeng.roses.kernel.log.api.factory.appender.ParamsLogAppender;
import cn.stylefeng.roses.kernel.log.api.pojo.record.LogRecordDTO;
import cn.stylefeng.roses.kernel.log.requestapi.LogRecordApi;
import cn.stylefeng.roses.kernel.rule.annotation.ApiLog;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;

@Aspect
public class RequestApiLogRecordAop
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(RequestApiLogRecordAop.class);
    private final LogRecordApi logRecordApi;

    public RequestApiLogRecordAop(LogRecordApi logRecordApi) {
        this.logRecordApi = logRecordApi;
    }

    @Pointcut(value="execution(* *..controller.*.*(..)) || execution(* *..*Controller.*(..))")
    public void cutService() {
    }

    @Around(value="cutService()")
    public Object aroundPost(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        try {
            boolean ensureMakeLog = this.ensureMakeLog(point);
            if (!ensureMakeLog) {
                return result;
            }
            if (ObjectUtil.isNotEmpty((Object)result)) {
                Map<String, Object> annotationProp = this.getAnnotationProp(point);
                Map<String, Object> args = this.getFieldsName(point);
                args.entrySet().removeIf(objectEntry -> objectEntry.getValue() instanceof HttpServletRequest || objectEntry.getValue() instanceof HttpServletResponse);
                this.recordLog(args, result, annotationProp);
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u8bb0\u5f55\u6ca1\u6709\u8bb0\u5f55\u6210\u529f\uff01", (Throwable)e);
        }
        return result;
    }

    private Map<String, Object> getAnnotationProp(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        HashMap<String, Object> propMap = new HashMap<String, Object>(2);
        Object name = null;
        Object requiredLogin = null;
        ApiResource apiResource = method.getAnnotation(ApiResource.class);
        GetResource getResource = method.getAnnotation(GetResource.class);
        PostResource postResource = method.getAnnotation(PostResource.class);
        if (apiResource != null) {
            propMap.put("name", apiResource.name());
            propMap.put("requiredLogin", apiResource.requiredLogin());
        }
        if (getResource != null) {
            propMap.put("name", getResource.name());
            propMap.put("requiredLogin", getResource.requiredLogin());
        }
        if (postResource != null) {
            propMap.put("name", postResource.name());
            propMap.put("requiredLogin", postResource.requiredLogin());
        }
        return propMap;
    }

    private void recordLog(Map<String, Object> params, Object result, Map<String, Object> annotationProp) {
        Object actionName = annotationProp.get("name");
        LogRecordDTO logRecordDTO = LogRecordFactory.createLogRecord((Object)actionName);
        LoginUser loginUserNullable = LoginContext.me().getLoginUserNullable();
        if (loginUserNullable != null) {
            AuthedLogAppender.appendAuthedHttpLog((LogRecordDTO)logRecordDTO, (String)loginUserNullable.getToken(), (Long)loginUserNullable.getUserId(), (Long)loginUserNullable.getCurrentOrgId());
        }
        HttpLogAppender.appendHttpLog((LogRecordDTO)logRecordDTO);
        ParamsLogAppender.appendAuthedHttpLog((LogRecordDTO)logRecordDTO, params, (Object)result);
        this.logRecordApi.addAsync(logRecordDTO);
    }

    public int getOrder() {
        return LogFileConstants.DEFAULT_API_LOG_AOP_SORT;
    }

    private Map<String, Object> getFieldsName(ProceedingJoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(args.length);
        try {
            String classType = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            Class[] classes = new Class[args.length];
            for (int k = 0; k < args.length; ++k) {
                classes[k] = args[k] instanceof Model ? Model.class : (args[k] instanceof MultipartFile ? MultipartFile.class : args[k].getClass());
            }
            DefaultParameterNameDiscoverer defaultParameterNameDiscoverer = new DefaultParameterNameDiscoverer();
            Method method = Class.forName(classType).getMethod(methodName, classes);
            String[] parameterNames = defaultParameterNameDiscoverer.getParameterNames(method);
            if (null == parameterNames) {
                return new HashMap<String, Object>(1);
            }
            for (int i = 0; i < parameterNames.length; ++i) {
                if (args[i] instanceof MultipartFile && args[i] != null) {
                    paramMap.put(parameterNames[i], ((MultipartFile)args[i]).getOriginalFilename());
                    continue;
                }
                paramMap.put(parameterNames[i], args[i]);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof MultipartFile && args[i] != null) {
                    paramMap.put("args" + i, ((MultipartFile)args[i]).getOriginalFilename());
                    continue;
                }
                paramMap.put("args" + i, args[i]);
            }
        }
        return paramMap;
    }

    private boolean ensureMakeLog(ProceedingJoinPoint point) {
        Boolean openFlag = LogConfigExpander.getGlobalControllerOpenFlag();
        Class<?> controllerClass = point.getTarget().getClass();
        ApiLog businessLog = controllerClass.getAnnotation(ApiLog.class);
        ApiLog methodBusinessLog = null;
        MethodSignature methodSignature = null;
        if (!(point.getSignature() instanceof MethodSignature)) {
            return false;
        }
        methodSignature = (MethodSignature)point.getSignature();
        Object target = point.getTarget();
        try {
            Method currentMethod = target.getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
            methodBusinessLog = currentMethod.getAnnotation(ApiLog.class);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (openFlag.booleanValue()) {
            if (businessLog != null && !businessLog.openLog()) {
                return false;
            }
            return methodBusinessLog == null || methodBusinessLog.openLog();
        }
        if (businessLog != null && businessLog.openLog()) {
            return true;
        }
        return methodBusinessLog != null && methodBusinessLog.openLog();
    }
}

