/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.requestapi.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.exception.LogException;
import cn.stylefeng.roses.kernel.log.api.exception.enums.LogExceptionEnum;
import cn.stylefeng.roses.kernel.log.api.pojo.manage.LogManagerRequest;
import cn.stylefeng.roses.kernel.log.api.pojo.record.LogRecordDTO;
import cn.stylefeng.roses.kernel.log.requestapi.entity.SysLog;
import cn.stylefeng.roses.kernel.log.requestapi.mapper.SysLogMapper;
import cn.stylefeng.roses.kernel.log.requestapi.service.SysLogService;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SysLogServiceImpl
extends ServiceImpl<SysLogMapper, SysLog>
implements SysLogService {
    @Override
    public void add(LogManagerRequest logManagerRequest) {
        SysLog sysLog = new SysLog();
        BeanUtil.copyProperties((Object)logManagerRequest, (Object)((Object)sysLog), (String[])new String[0]);
        this.save((Object)sysLog);
    }

    @Override
    public void delAll(LogManagerRequest logManagerRequest) {
        LambdaUpdateWrapper queryWrapper = new LambdaUpdateWrapper();
        queryWrapper.between(BaseEntity::getCreateTime, (Object)(logManagerRequest.getBeginDate() + " 00:00:00"), (Object)(logManagerRequest.getEndDate() + " 23:59:59"));
        queryWrapper.eq(SysLog::getAppName, (Object)logManagerRequest.getAppName());
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public SysLog detail(LogManagerRequest logManagerRequest) {
        return this.querySysLogById(logManagerRequest);
    }

    public PageResult<LogRecordDTO> apiLogPageQuery(LogManagerRequest logManagerRequest) {
        LambdaQueryWrapper<SysLog> wrapper = this.createWrapper(logManagerRequest);
        wrapper.select(new SFunction[]{SysLog::getLogId, SysLog::getRequestUrl, SysLog::getLogContent, SysLog::getUserId, SysLog::getUserCurrentOrgId, SysLog::getAppName, BaseEntity::getCreateTime});
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        List records = page.getRecords();
        List logRecordDTOS = BeanUtil.copyToList((Collection)records, LogRecordDTO.class, (CopyOptions)CopyOptions.create().ignoreError());
        return PageResultFactory.createPageResult((List)logRecordDTOS, (Long)page.getTotal(), (Integer)Convert.toInt((Object)page.getSize()), (Integer)Convert.toInt((Object)page.getCurrent()));
    }

    private SysLog querySysLogById(LogManagerRequest logManagerRequest) {
        SysLog sysLog = (SysLog)((Object)this.getById(logManagerRequest.getLogId()));
        if (sysLog == null) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.LOG_NOT_EXISTED, new Object[]{logManagerRequest.getLogId()});
        }
        return sysLog;
    }

    private LambdaQueryWrapper<SysLog> createWrapper(LogManagerRequest logManagerRequest) {
        Long userId;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)logManagerRequest.getOrderBy()) && ObjectUtil.isNotEmpty((Object)logManagerRequest.getSortBy())) {
            queryWrapper.last(logManagerRequest.getOrderByLastSql());
        } else {
            queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        }
        if (ObjectUtil.isEmpty((Object)logManagerRequest)) {
            return queryWrapper;
        }
        String beginDateTime = logManagerRequest.getBeginDate();
        String endDateTime = logManagerRequest.getEndDate();
        Date beginDate = null;
        Date endDate = null;
        if (StrUtil.isNotBlank((CharSequence)beginDateTime)) {
            beginDate = DateUtil.parseDateTime((CharSequence)(beginDateTime + " 00:00:00")).toJdkDate();
        }
        if (StrUtil.isNotBlank((CharSequence)endDateTime)) {
            endDate = DateUtil.parseDateTime((CharSequence)(endDateTime + " 23:59:59")).toJdkDate();
        }
        queryWrapper.between(ObjectUtil.isAllNotEmpty((Object[])new Object[]{beginDate, endDate}), BaseEntity::getCreateTime, (Object)beginDate, (Object)endDate);
        String appName = logManagerRequest.getAppName();
        queryWrapper.like(StrUtil.isNotEmpty((CharSequence)appName), SysLog::getAppName, (Object)appName);
        String searchText = logManagerRequest.getSearchText();
        if (StrUtil.isNotEmpty((CharSequence)searchText)) {
            queryWrapper.nested(wrap -> ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.likeRight(SysLog::getRequestUrl, (Object)searchText)).or()).likeRight(SysLog::getLogContent, (Object)searchText));
        }
        if (ObjectUtil.isNotEmpty((Object)(userId = logManagerRequest.getUserId()))) {
            queryWrapper.eq(SysLog::getUserId, (Object)userId);
        }
        return queryWrapper;
    }
}

