/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.org.factory;

import cn.hutool.core.convert.Convert;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.sys.modular.org.entity.HrOrganization;
import cn.stylefeng.roses.kernel.sys.modular.org.pojo.request.HrOrganizationRequest;
import cn.stylefeng.roses.kernel.sys.modular.org.service.HrOrganizationService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OrganizationFactory {
    public static Set<Long> getOrgParentIdList(List<HrOrganization> organizationList) {
        HashSet<Long> orgIdList = new HashSet<Long>();
        for (HrOrganization hrOrganization : organizationList) {
            String[] orgParentIdList;
            String orgParentIdListStr = hrOrganization.getOrgPids();
            orgParentIdListStr = orgParentIdListStr.replaceAll("\\[", "");
            orgParentIdListStr = orgParentIdListStr.replaceAll("]", "");
            for (String orgIdStr : orgParentIdList = orgParentIdListStr.split(",")) {
                Long orgId = Convert.toLong((Object)orgIdStr);
                orgIdList.add(orgId);
            }
        }
        return orgIdList;
    }

    public static void fillParentIds(HrOrganization hrOrganization) {
        if (TreeConstants.DEFAULT_PARENT_ID.equals(hrOrganization.getOrgParentId())) {
            hrOrganization.setOrgPids("[" + TreeConstants.DEFAULT_PARENT_ID + "]" + ",");
        } else {
            HrOrganizationService hrOrganizationService = (HrOrganizationService)SpringUtil.getBean(HrOrganizationService.class);
            HrOrganizationRequest hrOrganizationRequest = new HrOrganizationRequest();
            hrOrganizationRequest.setOrgId(hrOrganization.getOrgParentId());
            HrOrganization parentOrganization = hrOrganizationService.detail(hrOrganizationRequest);
            hrOrganization.setOrgPids(parentOrganization.getOrgPids() + "[" + parentOrganization.getOrgId() + "]" + ",");
        }
    }
}

