/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.org.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.context.DbOperatorContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.db.mp.datascope.annotations.DataScope;
import cn.stylefeng.roses.kernel.dsctn.api.context.DataSourceContext;
import cn.stylefeng.roses.kernel.event.sdk.publish.BusinessEventPublisher;
import cn.stylefeng.roses.kernel.log.api.util.BusinessLogUtil;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveOrgCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.constants.SysConstants;
import cn.stylefeng.roses.kernel.sys.api.enums.org.DetectModeEnum;
import cn.stylefeng.roses.kernel.sys.api.enums.org.OrgTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.exception.enums.OrgExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.org.CompanyDeptDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.org.HrOrganizationDTO;
import cn.stylefeng.roses.kernel.sys.modular.org.entity.HrOrganization;
import cn.stylefeng.roses.kernel.sys.modular.org.factory.OrganizationFactory;
import cn.stylefeng.roses.kernel.sys.modular.org.mapper.HrOrganizationMapper;
import cn.stylefeng.roses.kernel.sys.modular.org.pojo.request.CommonOrgTreeRequest;
import cn.stylefeng.roses.kernel.sys.modular.org.pojo.request.HrOrganizationRequest;
import cn.stylefeng.roses.kernel.sys.modular.org.pojo.response.CommonOrgTreeResponse;
import cn.stylefeng.roses.kernel.sys.modular.org.pojo.response.HomeCompanyInfo;
import cn.stylefeng.roses.kernel.sys.modular.org.service.HrOrganizationService;
import cn.stylefeng.roses.kernel.sys.modular.position.service.HrPositionService;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUserOrg;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserOrgService;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HrOrganizationServiceImpl
extends ServiceImpl<HrOrganizationMapper, HrOrganization>
implements HrOrganizationService {
    @Resource
    private SysUserService sysUserService;
    @Resource
    private HrPositionService hrPositionService;
    @Resource
    private SysUserOrgService sysUserOrgService;
    @Resource(name="sysOrgSubFlagCache")
    private CacheOperatorApi<Boolean> sysOrgSubFlagCache;

    @Override
    public void add(HrOrganizationRequest hrOrganizationRequest) {
        HrOrganization hrOrganization = new HrOrganization();
        BeanUtil.copyProperties((Object)((Object)hrOrganizationRequest), (Object)((Object)hrOrganization), (String[])new String[0]);
        OrganizationFactory.fillParentIds(hrOrganization);
        this.save((Object)hrOrganization);
        BusinessEventPublisher.publishEvent((String)"ADD_ORG_EVENT", (Object)((Object)hrOrganization));
        BusinessLogUtil.setLogTitle((String)("\u6dfb\u52a0\u673a\u6784\uff0c\u673a\u6784\u540d\u79f0\uff1a" + hrOrganizationRequest.getOrgName()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u65b0\u589e\u7684\u673a\u6784\u8be6\u60c5\u5982\u4e0b\uff1a\n", hrOrganization});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(HrOrganizationRequest hrOrganizationRequest) {
        Set totalOrgIdSet = DbOperatorContext.me().findSubListByParentId("sys_hr_organization", "org_pids", "org_id", hrOrganizationRequest.getOrgId());
        totalOrgIdSet.add(hrOrganizationRequest.getOrgId());
        this.baseDelete(totalOrgIdSet);
        BusinessEventPublisher.publishEvent((String)"DELETE_ORG_EVENT", null);
        BusinessLogUtil.setLogTitle((String)("\u5220\u9664\u673a\u6784\uff0c\u673a\u6784ID\uff1a" + hrOrganizationRequest.getOrgId()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u5220\u9664\u673a\u6784\uff0c\u673a\u6784ID\uff1a", hrOrganizationRequest.getOrgId()});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(HrOrganizationRequest hrOrganizationRequest) {
        Set<Long> orgIdList = hrOrganizationRequest.getOrgIdList();
        for (Long orgId : orgIdList) {
            Set tempSubOrgIdList = DbOperatorContext.me().findSubListByParentId("sys_hr_organization", "org_pids", "org_id", orgId);
            orgIdList.addAll(tempSubOrgIdList);
        }
        this.baseDelete(orgIdList);
        BusinessEventPublisher.publishEvent((String)"DELETE_ORG_EVENT", null);
        BusinessLogUtil.setLogTitle((String)"\u6279\u91cf\u5220\u9664\u673a\u6784", (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u6279\u91cf\u5220\u9664\u673a\u6784\uff0cid\u96c6\u5408\u4e3a\uff1a", orgIdList});
    }

    @Override
    public void edit(HrOrganizationRequest hrOrganizationRequest) {
        HrOrganization hrOrganization = this.queryHrOrganization(hrOrganizationRequest);
        BusinessLogUtil.setLogTitle((String)"\u66f4\u65b0\u673a\u6784\u4fe1\u606f\uff0c\u673a\u6784\u540d\u79f0\u4e3a\uff1a", (String[])new String[]{hrOrganization.getOrgName()});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u66f4\u65b0\u524d\u7684\u673a\u6784\u4fe1\u606f\u4e3a\uff1a\n", hrOrganization});
        BeanUtil.copyProperties((Object)((Object)hrOrganizationRequest), (Object)((Object)hrOrganization), (String[])new String[0]);
        OrganizationFactory.fillParentIds(hrOrganization);
        this.updateById((Object)hrOrganization);
        BusinessEventPublisher.publishEvent((String)"EDIT_ORG_EVENT", null);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u66f4\u65b0\u540e\u7684\u673a\u6784\u4fe1\u606f\u4e3a\uff1a\n", hrOrganization});
    }

    @Override
    public HrOrganization detail(HrOrganizationRequest hrOrganizationRequest) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(HrOrganization::getOrgId, (Object)hrOrganizationRequest.getOrgId());
        wrapper.select(new SFunction[]{HrOrganization::getOrgId, HrOrganization::getOrgName, HrOrganization::getOrgShortName, HrOrganization::getOrgCode, HrOrganization::getOrgParentId, HrOrganization::getOrgSort, HrOrganization::getOrgType, HrOrganization::getStatusFlag, HrOrganization::getTaxNo, HrOrganization::getRemark, HrOrganization::getOrgPids});
        HrOrganization hrOrganization = (HrOrganization)((Object)this.getOne((Wrapper)wrapper, false));
        if (ObjectUtil.isEmpty((Object)((Object)hrOrganization))) {
            throw new ServiceException((AbstractExceptionEnum)OrgExceptionEnum.HR_ORGANIZATION_NOT_EXISTED);
        }
        String parentOrgName = this.getOrgNameById(hrOrganization.getOrgParentId());
        hrOrganization.setParentOrgName(parentOrgName);
        return hrOrganization;
    }

    @Override
    public List<HrOrganization> findList(HrOrganizationRequest hrOrganizationRequest) {
        LambdaQueryWrapper<HrOrganization> wrapper = this.createWrapper(hrOrganizationRequest);
        return this.list((Wrapper)wrapper);
    }

    @Override
    @DataScope(userIdFieldName="create_user")
    public PageResult<HrOrganization> findPage(HrOrganizationRequest hrOrganizationRequest) {
        LambdaQueryWrapper<HrOrganization> wrapper = this.createWrapper(hrOrganizationRequest);
        wrapper.select(new SFunction[]{HrOrganization::getOrgId, HrOrganization::getOrgName, HrOrganization::getOrgCode, HrOrganization::getStatusFlag, HrOrganization::getOrgType, HrOrganization::getOrgSort, BaseEntity::getCreateTime});
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    @DataScope(userIdFieldName="create_user")
    public PageResult<HrOrganization> commonOrgPage(HrOrganizationRequest hrOrganizationRequest) {
        hrOrganizationRequest.setStatusFlag(StatusEnum.ENABLE.getCode());
        LambdaQueryWrapper<HrOrganization> wrapper = this.createWrapper(hrOrganizationRequest);
        wrapper.select(new SFunction[]{HrOrganization::getOrgId, HrOrganization::getOrgName, HrOrganization::getOrgCode, HrOrganization::getOrgType, HrOrganization::getStatusFlag, HrOrganization::getOrgParentId});
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        for (HrOrganization hrOrganization : sysRolePage.getRecords()) {
            CompanyDeptDTO companyInfo = this.getOrgCompanyInfo(hrOrganization);
            if (companyInfo == null) continue;
            hrOrganization.setCompanyName(companyInfo.getCompanyName());
        }
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    @DataScope(userIdFieldName="create_user")
    public CommonOrgTreeResponse commonOrgTree(CommonOrgTreeRequest commonOrgTreeRequest) {
        if (ObjectUtil.isNotEmpty((Object)commonOrgTreeRequest.getSearchText())) {
            commonOrgTreeRequest.setOrgParentId(null);
            commonOrgTreeRequest.setIndexOrgIdList(null);
        }
        if (ObjectUtil.isNotEmpty(commonOrgTreeRequest.getIndexOrgIdList())) {
            commonOrgTreeRequest.setOrgParentId(null);
        }
        LambdaQueryWrapper<HrOrganization> wrapper = this.createCommonTreeWrapper(commonOrgTreeRequest);
        wrapper.select(new SFunction[]{HrOrganization::getOrgId, HrOrganization::getOrgPids, HrOrganization::getOrgParentId, HrOrganization::getOrgName, HrOrganization::getOrgSort, HrOrganization::getOrgType});
        List hrOrganizationList = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)hrOrganizationList)) {
            return new CommonOrgTreeResponse(hrOrganizationList, new ArrayList<Long>());
        }
        String searchText = commonOrgTreeRequest.getSearchText();
        List parentOrgList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            Set<Long> orgParentIdList = OrganizationFactory.getOrgParentIdList(hrOrganizationList);
            LambdaQueryWrapper parentWrapper = new LambdaQueryWrapper();
            parentWrapper.in(HrOrganization::getOrgId, orgParentIdList);
            parentOrgList = this.list((Wrapper)parentWrapper);
        }
        hrOrganizationList.addAll(parentOrgList);
        List newNotRepeatList = hrOrganizationList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<HrOrganization>(Comparator.comparing(HrOrganization::getOrgId))), LinkedList::new));
        newNotRepeatList.sort(Comparator.comparing(HrOrganization::getOrgSort));
        if (ObjectUtil.isNotEmpty((Object)commonOrgTreeRequest.getSearchText()) || ObjectUtil.isNotEmpty(commonOrgTreeRequest.getIndexOrgIdList())) {
            newNotRepeatList = new DefaultTreeBuildFactory().doTreeBuild(newNotRepeatList);
        }
        this.fillHaveSubFlag(newNotRepeatList);
        ArrayList<Long> expandOrgIds = new ArrayList<Long>();
        this.fillExpandFlag(newNotRepeatList, expandOrgIds);
        return new CommonOrgTreeResponse(newNotRepeatList, expandOrgIds);
    }

    public CompanyDeptDTO getCompanyDeptInfo(Long orgId) {
        if (orgId == null) {
            return null;
        }
        HrOrganization hrOrganization = (HrOrganization)((Object)this.getById(orgId));
        if (hrOrganization == null) {
            return null;
        }
        if (OrgTypeEnum.COMPANY.getCode().equals(hrOrganization.getOrgType())) {
            return new CompanyDeptDTO(hrOrganization.getOrgId(), hrOrganization.getOrgName());
        }
        CompanyDeptDTO orgCompanyInfo = this.getOrgCompanyInfo(hrOrganization);
        if (orgCompanyInfo != null) {
            orgCompanyInfo.setDeptId(hrOrganization.getOrgId());
            orgCompanyInfo.setDeptName(hrOrganization.getOrgName());
        }
        return orgCompanyInfo;
    }

    @Override
    public CompanyDeptDTO getOrgCompanyInfo(HrOrganization hrOrganization) {
        if (hrOrganization == null) {
            return null;
        }
        if (TreeConstants.DEFAULT_PARENT_ID.equals(hrOrganization.getOrgParentId())) {
            return new CompanyDeptDTO(hrOrganization.getOrgId(), hrOrganization.getOrgName());
        }
        if (OrgTypeEnum.COMPANY.getCode().equals(hrOrganization.getOrgType())) {
            return new CompanyDeptDTO(hrOrganization.getOrgId(), hrOrganization.getOrgName());
        }
        Long orgParentId = hrOrganization.getOrgParentId();
        HrOrganization parentOrgInfo = (HrOrganization)((Object)this.getById(orgParentId));
        return this.getOrgCompanyInfo(parentOrgInfo);
    }

    public CompanyDeptDTO getOrgCompanyInfo(Long orgId) {
        if (orgId == null) {
            return null;
        }
        LambdaQueryWrapper hrOrganizationLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrganizationLambdaQueryWrapper.eq(HrOrganization::getOrgId, (Object)orgId);
        hrOrganizationLambdaQueryWrapper.select(new SFunction[]{HrOrganization::getOrgType, HrOrganization::getOrgId, HrOrganization::getOrgParentId});
        HrOrganization hrOrganization = (HrOrganization)((Object)this.getOne((Wrapper)hrOrganizationLambdaQueryWrapper, false));
        if (hrOrganization == null) {
            return null;
        }
        return this.getOrgCompanyInfo(hrOrganization);
    }

    public HrOrganizationDTO getOrgInfo(Long orgId) {
        LambdaQueryWrapper hrOrganizationLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrganizationLambdaQueryWrapper.eq(HrOrganization::getOrgId, (Object)orgId);
        hrOrganizationLambdaQueryWrapper.select(new SFunction[]{HrOrganization::getOrgId, HrOrganization::getOrgParentId, HrOrganization::getOrgPids, HrOrganization::getOrgName, HrOrganization::getOrgShortName, HrOrganization::getOrgSort, HrOrganization::getOrgCode});
        HrOrganization hrOrganization = (HrOrganization)((Object)this.getOne((Wrapper)hrOrganizationLambdaQueryWrapper, false));
        if (ObjectUtil.isEmpty((Object)((Object)hrOrganization))) {
            return new HrOrganizationDTO();
        }
        HrOrganizationDTO hrOrganizationDTO = new HrOrganizationDTO();
        BeanUtil.copyProperties((Object)((Object)hrOrganization), (Object)hrOrganizationDTO, (String[])new String[0]);
        return hrOrganizationDTO;
    }

    public List<HrOrganizationDTO> getOrgNameList(Collection<Long> orgIdList) {
        LambdaQueryWrapper hrOrganizationLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrganizationLambdaQueryWrapper.in(HrOrganization::getOrgId, orgIdList);
        hrOrganizationLambdaQueryWrapper.select(new SFunction[]{HrOrganization::getOrgId, HrOrganization::getOrgName});
        List list2 = this.list((Wrapper)hrOrganizationLambdaQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)list2)) {
            return BeanUtil.copyToList((Collection)list2, HrOrganizationDTO.class);
        }
        return new ArrayList<HrOrganizationDTO>();
    }

    @Override
    public HomeCompanyInfo orgStatInfo() {
        HomeCompanyInfo homeCompanyInfo = new HomeCompanyInfo();
        long totalOrgCount = this.count();
        homeCompanyInfo.setOrganizationNum(totalOrgCount);
        long totalUserCount = this.sysUserService.count();
        homeCompanyInfo.setEnterprisePersonNum(totalUserCount);
        long totalPositionCount = this.hrPositionService.count();
        homeCompanyInfo.setPositionNum(totalPositionCount);
        Long currentOrgId = LoginContext.me().getLoginUser().getCurrentOrgId();
        CompanyDeptDTO orgCompanyInfo = this.getOrgCompanyInfo(currentOrgId);
        if (currentOrgId == null || orgCompanyInfo == null) {
            homeCompanyInfo.setCurrentCompanyPersonNum(0L);
            homeCompanyInfo.setCurrentCompanyPersonNum(0L);
            return homeCompanyInfo;
        }
        Long companyId = orgCompanyInfo.getCompanyId();
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(HrOrganization.class).like(HrOrganization::getOrgPids, (Object)("[" + companyId + "]"))).or()).eq(HrOrganization::getOrgId, (Object)companyId)).select(new SFunction[]{HrOrganization::getOrgId});
        List organizations = this.list((Wrapper)wrapper);
        homeCompanyInfo.setCurrentDeptNum(organizations.size());
        if (ObjectUtil.isEmpty((Object)organizations)) {
            homeCompanyInfo.setCurrentCompanyPersonNum(0L);
        } else {
            List orgIdList = organizations.stream().map(HrOrganization::getOrgId).collect(Collectors.toList());
            LambdaQueryWrapper userWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUserOrg::getOrgId, orgIdList);
            userWrapper.select(new SFunction[]{SysUserOrg::getUserId});
            List list2 = this.sysUserOrgService.list((Wrapper)userWrapper);
            Set currentOrgUserSize = list2.stream().map(SysUserOrg::getUserId).collect(Collectors.toSet());
            homeCompanyInfo.setCurrentCompanyPersonNum(Convert.toLong((Object)currentOrgUserSize.size()));
        }
        return homeCompanyInfo;
    }

    @Override
    public Set<Long> queryOrgIdParentIdList(Set<Long> orgIdList) {
        HashSet<Long> parentIdListTotal = new HashSet<Long>();
        if (ObjectUtil.isEmpty(orgIdList)) {
            return parentIdListTotal;
        }
        parentIdListTotal.addAll(orgIdList);
        LambdaQueryWrapper hrOrganizationLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrganizationLambdaQueryWrapper.in(HrOrganization::getOrgId, orgIdList);
        hrOrganizationLambdaQueryWrapper.select(new SFunction[]{HrOrganization::getOrgPids});
        List hrOrganizationList = this.list((Wrapper)hrOrganizationLambdaQueryWrapper);
        for (HrOrganization hrOrganization : hrOrganizationList) {
            String[] split;
            String orgPids = hrOrganization.getOrgPids();
            if (ObjectUtil.isEmpty((Object)orgPids)) continue;
            orgPids = orgPids.replaceAll("\\[", "");
            orgPids = orgPids.replaceAll("]", "");
            for (String pidString : split = orgPids.split(",")) {
                parentIdListTotal.add(Convert.toLong((Object)pidString));
            }
        }
        return parentIdListTotal;
    }

    @Override
    public Boolean getOrgHaveSubFlag(Long orgId) {
        if (ObjectUtil.isEmpty((Object)orgId)) {
            return false;
        }
        Boolean cacheResult = (Boolean)this.sysOrgSubFlagCache.get(orgId.toString());
        if (cacheResult != null) {
            return cacheResult;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(HrOrganization::getOrgParentId, (Object)orgId);
        wrapper.select(new SFunction[]{HrOrganization::getOrgId});
        List hrOrganizationList = this.list((Wrapper)wrapper);
        if (hrOrganizationList.size() > 0) {
            this.sysOrgSubFlagCache.put(orgId.toString(), (Object)true, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
            return true;
        }
        this.sysOrgSubFlagCache.put(orgId.toString(), (Object)false, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
        return false;
    }

    @Override
    public List<SimpleDict> getOrgListName(HrOrganizationRequest hrOrganizationRequest) {
        ArrayList<SimpleDict> dictList = new ArrayList<SimpleDict>();
        if (ObjectUtil.isEmpty((Object)((Object)hrOrganizationRequest)) || ObjectUtil.isEmpty(hrOrganizationRequest.getOrgIdList())) {
            return dictList;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(HrOrganization::getOrgId, hrOrganizationRequest.getOrgIdList());
        wrapper.select(new SFunction[]{HrOrganization::getOrgName, HrOrganization::getOrgId, HrOrganization::getOrgCode});
        List list2 = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)list2)) {
            return dictList;
        }
        for (HrOrganization hrOrganization : list2) {
            dictList.add(new SimpleDict(hrOrganization.getOrgId(), hrOrganization.getOrgName(), hrOrganization.getOrgCode()));
        }
        return dictList;
    }

    @Override
    public void quickBatchSaveOrg(List<HrOrganization> batchOrgList) {
        if (DbTypeEnum.MYSQL.equals((Object)DataSourceContext.me().getCurrentDbType())) {
            ((HrOrganizationMapper)this.getBaseMapper()).insertBatchSomeColumn(batchOrgList);
        } else {
            this.saveBatch(batchOrgList);
        }
    }

    public String getOrgNameById(Long orgId) {
        if (TreeConstants.DEFAULT_PARENT_ID.equals(orgId)) {
            return "\u65e0\u4e0a\u7ea7\u673a\u6784";
        }
        if (ObjectUtil.isEmpty((Object)orgId)) {
            return "\u65e0\u4e0a\u7ea7\u673a\u6784";
        }
        LambdaQueryWrapper hrOrganizationLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrganizationLambdaQueryWrapper.eq(HrOrganization::getOrgId, (Object)orgId);
        hrOrganizationLambdaQueryWrapper.select(new SFunction[]{HrOrganization::getOrgName});
        HrOrganization one = (HrOrganization)((Object)this.getOne((Wrapper)hrOrganizationLambdaQueryWrapper));
        if (one != null) {
            return one.getOrgName();
        }
        return "\u65e0\u4e0a\u7ea7\u673a\u6784";
    }

    public Long getParentLevelOrgId(Long orgId, Integer parentLevelNum, DetectModeEnum detectModeEnum) {
        if (DetectModeEnum.TO_TOP.equals((Object)detectModeEnum)) {
            return this.calcParentOrgId(orgId, parentLevelNum, true);
        }
        return this.calcParentOrgId(orgId, parentLevelNum, false);
    }

    public CompanyDeptDTO remoteGetOrgCompanyDept(Long orgId) {
        return this.getOrgCompanyInfo(orgId);
    }

    private HrOrganization queryHrOrganization(HrOrganizationRequest hrOrganizationRequest) {
        HrOrganization hrOrganization = (HrOrganization)((Object)this.getById(hrOrganizationRequest.getOrgId()));
        if (ObjectUtil.isEmpty((Object)((Object)hrOrganization))) {
            throw new ServiceException((AbstractExceptionEnum)OrgExceptionEnum.HR_ORGANIZATION_NOT_EXISTED);
        }
        return hrOrganization;
    }

    private LambdaQueryWrapper<HrOrganization> createWrapper(HrOrganizationRequest hrOrganizationRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = hrOrganizationRequest.getSearchText();
        if (StrUtil.isNotEmpty((CharSequence)searchText)) {
            queryWrapper.nested(wrap -> {
                wrap.like(HrOrganization::getOrgName, (Object)searchText);
                ((LambdaQueryWrapper)wrap.or()).like(HrOrganization::getOrgShortName, (Object)searchText);
                ((LambdaQueryWrapper)wrap.or()).like(HrOrganization::getTaxNo, (Object)searchText);
                ((LambdaQueryWrapper)wrap.or()).like(HrOrganization::getOrgCode, (Object)searchText);
                ((LambdaQueryWrapper)wrap.or()).like(HrOrganization::getRemark, (Object)searchText);
            });
        }
        Integer statusFlag = hrOrganizationRequest.getStatusFlag();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)statusFlag), HrOrganization::getStatusFlag, (Object)statusFlag);
        Long orgId = hrOrganizationRequest.getOrgId();
        if (orgId != null) {
            queryWrapper.nested(wrap -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrap.eq(HrOrganization::getOrgParentId, (Object)orgId)).or()).eq(HrOrganization::getOrgId, (Object)orgId));
        }
        queryWrapper.orderByAsc(HrOrganization::getOrgSort);
        return queryWrapper;
    }

    private void baseDelete(Set<Long> totalOrgIdSet) {
        Map callbackApiMap = SpringUtil.getBeansOfType(RemoveOrgCallbackApi.class);
        for (RemoveOrgCallbackApi removeOrgCallbackApi : callbackApiMap.values()) {
            removeOrgCallbackApi.validateHaveOrgBind(totalOrgIdSet);
        }
        for (RemoveOrgCallbackApi removeOrgCallbackApi : callbackApiMap.values()) {
            removeOrgCallbackApi.removeOrgAction(totalOrgIdSet);
        }
        this.removeBatchByIds(totalOrgIdSet);
    }

    private LambdaQueryWrapper<HrOrganization> createCommonTreeWrapper(CommonOrgTreeRequest commonOrgTreeRequest) {
        Boolean companySearchFlag;
        Set<Long> parentIdListTotal;
        Set<Long> indexOrgIdList;
        HrOrganizationRequest hrOrganizationRequest = new HrOrganizationRequest();
        hrOrganizationRequest.setSearchText(commonOrgTreeRequest.getSearchText());
        LambdaQueryWrapper<HrOrganization> queryWrapper = this.createWrapper(hrOrganizationRequest);
        Long parentId = commonOrgTreeRequest.getOrgParentId();
        if (parentId != null) {
            queryWrapper.eq(HrOrganization::getOrgParentId, (Object)parentId);
        }
        if (ObjectUtil.isNotEmpty(indexOrgIdList = commonOrgTreeRequest.getIndexOrgIdList()) && ObjectUtil.isNotEmpty(parentIdListTotal = this.queryOrgIdParentIdList(indexOrgIdList))) {
            queryWrapper.in(HrOrganization::getOrgParentId, parentIdListTotal);
        }
        if (ObjectUtil.isNotEmpty((Object)(companySearchFlag = commonOrgTreeRequest.getCompanySearchFlag())) && companySearchFlag.booleanValue()) {
            queryWrapper.eq(HrOrganization::getOrgType, (Object)OrgTypeEnum.COMPANY.getCode());
        }
        queryWrapper.eq(HrOrganization::getStatusFlag, (Object)StatusEnum.ENABLE.getCode());
        return queryWrapper;
    }

    private void fillHaveSubFlag(List<HrOrganization> organizations) {
        if (ObjectUtil.isEmpty(organizations)) {
            return;
        }
        for (HrOrganization organization : organizations) {
            Long orgId = organization.getOrgId();
            Boolean orgHaveSubFlag = this.getOrgHaveSubFlag(orgId);
            organization.setHaveSubOrgFlag(orgHaveSubFlag);
            if (!ObjectUtil.isNotEmpty(organization.getChildren())) continue;
            this.fillHaveSubFlag(organization.getChildren());
        }
    }

    private void fillExpandFlag(List<HrOrganization> organizations, List<Long> expandOrgIds) {
        if (ObjectUtil.isEmpty(organizations)) {
            return;
        }
        for (HrOrganization organization : organizations) {
            Long orgId = organization.getOrgId();
            if (!ObjectUtil.isNotEmpty(organization.getChildren())) continue;
            expandOrgIds.add(orgId);
            this.fillExpandFlag(organization.getChildren(), expandOrgIds);
        }
    }

    private Long calcParentOrgId(Long orgId, Integer parentLevelNum, boolean reverse) {
        String orgIdString;
        if (ObjectUtil.isEmpty((Object)orgId) || ObjectUtil.isEmpty((Object)parentLevelNum)) {
            return null;
        }
        if (parentLevelNum == 0) {
            return orgId;
        }
        HrOrganization hrOrganization = (HrOrganization)((Object)this.getById(orgId));
        if (hrOrganization == null || StrUtil.isEmpty((CharSequence)hrOrganization.getOrgPids())) {
            return null;
        }
        String orgParentIdListStr = hrOrganization.getOrgPids();
        orgParentIdListStr = orgParentIdListStr.replaceAll("\\[", "");
        orgParentIdListStr = orgParentIdListStr.replaceAll("]", "");
        Object[] orgParentIdList = orgParentIdListStr.split(",");
        if (reverse) {
            orgParentIdList = (String[])ArrayUtil.reverse((Object[])orgParentIdList);
        }
        ArrayList<Object> parentOrgIdList = new ArrayList<Object>();
        for (Object orgIdItem : orgParentIdList) {
            if (TreeConstants.DEFAULT_PARENT_ID.toString().equals(orgIdItem)) continue;
            parentOrgIdList.add(orgIdItem);
        }
        int needGetArrayIndex = parentLevelNum - 1;
        int maxCanGetIndex = parentOrgIdList.size() - 1;
        if (maxCanGetIndex < 0) {
            return orgId;
        }
        if (needGetArrayIndex <= maxCanGetIndex) {
            orgIdString = (String)parentOrgIdList.get(needGetArrayIndex);
        } else if (reverse) {
            orgIdString = (String)parentOrgIdList.get(maxCanGetIndex);
        } else {
            return orgId;
        }
        return Long.valueOf(orgIdString);
    }
}

