/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.user.controller;

import cn.stylefeng.roses.kernel.rule.annotation.ApiLog;
import cn.stylefeng.roses.kernel.rule.enums.ResBizTypeEnum;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.request.SysUserRequest;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.response.PersonalInfo;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserService;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u4e2a\u4eba\u4fe1\u606f", resBizType=ResBizTypeEnum.SYSTEM)
public class PersonalInfoController {
    @Resource
    private SysUserService sysUserService;

    @GetResource(name="\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f\u8be6\u60c5", path={"/personalInfo/getUserInfo"})
    public ResponseData<PersonalInfo> getUserInfo() {
        PersonalInfo personalInfo = this.sysUserService.getPersonalInfo();
        return new SuccessResponseData((Object)personalInfo);
    }

    @PostResource(name="\u66f4\u65b0\u4e2a\u4eba\u4fe1\u606f", path={"/personalInfo/updateInfo"})
    @ApiLog
    public ResponseData<?> updateInfo(@RequestBody @Validated(value={SysUserRequest.updateInfo.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.editInfo(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u4fee\u6539\u4e2a\u4eba\u5934\u50cf", path={"/personalInfo/updateAvatar"})
    @ApiLog
    public ResponseData<?> updateAvatar(@RequestBody @Validated(value={SysUserRequest.updateAvatar.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.editAvatar(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u4fee\u6539\u4e2a\u4eba\u5bc6\u7801", path={"/personalInfo/updatePassword"})
    @ApiLog
    public ResponseData<?> updatePwd(@RequestBody @Validated(value={SysUserRequest.updatePwd.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.editPassword(sysUserRequest);
        return new SuccessResponseData();
    }
}

