/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.user.factory;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.db.api.DbOperatorApi;
import cn.stylefeng.roses.kernel.db.mp.datascope.UserRoleDataScopeApi;
import cn.stylefeng.roses.kernel.db.mp.datascope.config.DataScopeConfig;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUser;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserOrgService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserDataScopeFactory {
    public static void getUserDataScopeCondition(LambdaQueryWrapper<SysUser> queryWrapper) {
        UserRoleDataScopeApi userRoleDataScopeApi = (UserRoleDataScopeApi)SpringUtil.getBean(UserRoleDataScopeApi.class);
        SysUserOrgService sysUserOrgService = (SysUserOrgService)SpringUtil.getBean(SysUserOrgService.class);
        DbOperatorApi dbOperatorApi = (DbOperatorApi)SpringUtil.getBean(DbOperatorApi.class);
        DataScopeConfig userRoleDataScopeConfig = userRoleDataScopeApi.getUserRoleDataScopeConfig();
        switch (userRoleDataScopeConfig.getDataScopeType()) {
            case SELF: {
                queryWrapper.eq(SysUser::getUserId, (Object)userRoleDataScopeConfig.getUserId());
                break;
            }
            case DEPT: {
                Set deptUserIdList = sysUserOrgService.getOrgUserIdList(CollectionUtil.set((boolean)false, (Object[])new Long[]{userRoleDataScopeConfig.getUserDeptId()}));
                if (ObjectUtil.isEmpty((Object)deptUserIdList)) {
                    deptUserIdList = CollectionUtil.set((boolean)false, (Object[])new Long[]{-1L});
                }
                queryWrapper.in(SysUser::getUserId, (Collection)deptUserIdList);
                break;
            }
            case DEPT_WITH_CHILD: {
                HashSet<Long> subDeptOrgIdList = dbOperatorApi.findSubListByParentId("sys_hr_organization", "org_pids", "org_id", userRoleDataScopeConfig.getUserDeptId());
                if (ObjectUtil.isEmpty((Object)subDeptOrgIdList)) {
                    subDeptOrgIdList = new HashSet<Long>();
                }
                subDeptOrgIdList.add(userRoleDataScopeConfig.getUserDeptId());
                Set subDeptOrgUserIdList = sysUserOrgService.getOrgUserIdList(subDeptOrgIdList);
                if (ObjectUtil.isEmpty((Object)subDeptOrgUserIdList)) {
                    subDeptOrgUserIdList = CollectionUtil.set((boolean)false, (Object[])new Long[]{-1L});
                }
                queryWrapper.in(SysUser::getUserId, (Collection)subDeptOrgUserIdList);
                break;
            }
            case COMPANY_WITH_CHILD: {
                HashSet<Long> subCompanyOrgIdList = dbOperatorApi.findSubListByParentId("sys_hr_organization", "org_pids", "org_id", userRoleDataScopeConfig.getUserCompanyId());
                if (ObjectUtil.isEmpty((Object)subCompanyOrgIdList)) {
                    subCompanyOrgIdList = new HashSet<Long>();
                }
                subCompanyOrgIdList.add(userRoleDataScopeConfig.getUserCompanyId());
                Set subCompanyUserIdList = sysUserOrgService.getOrgUserIdList(subCompanyOrgIdList);
                if (ObjectUtil.isEmpty((Object)subCompanyUserIdList)) {
                    subCompanyUserIdList = CollectionUtil.set((boolean)false, (Object[])new Long[]{-1L});
                }
                queryWrapper.in(SysUser::getUserId, (Collection)subCompanyUserIdList);
                break;
            }
            case DEFINE: {
                Set specificOrgUserIdList;
                List specificOrgIds = userRoleDataScopeConfig.getSpecificOrgIds();
                if (ObjectUtil.isEmpty((Object)specificOrgIds)) {
                    specificOrgIds = CollectionUtil.list((boolean)false, (Object[])new Long[]{-1L});
                }
                if (ObjectUtil.isEmpty((Object)(specificOrgUserIdList = sysUserOrgService.getOrgUserIdList(new HashSet(specificOrgIds))))) {
                    specificOrgUserIdList = CollectionUtil.set((boolean)false, (Object[])new Long[]{-1L});
                }
                queryWrapper.in(SysUser::getUserId, (Collection)specificOrgUserIdList);
                break;
            }
        }
    }
}

