/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.app.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.modular.app.entity.SysApp;
import cn.stylefeng.roses.kernel.sys.modular.app.enums.SysAppExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.app.mapper.SysAppMapper;
import cn.stylefeng.roses.kernel.sys.modular.app.pojo.request.SysAppRequest;
import cn.stylefeng.roses.kernel.sys.modular.app.service.SysAppService;
import cn.stylefeng.roses.kernel.sys.modular.login.pojo.IndexUserAppInfo;
import cn.stylefeng.roses.kernel.sys.modular.menu.pojo.response.AppGroupDetail;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysAppServiceImpl
extends ServiceImpl<SysAppMapper, SysApp>
implements SysAppService {
    @Resource
    private SysMenuService sysMenuService;

    @Override
    public void add(SysAppRequest sysAppRequest) {
        SysApp sysApp = new SysApp();
        BeanUtil.copyProperties((Object)((Object)sysAppRequest), (Object)((Object)sysApp), (String[])new String[0]);
        this.save((Object)sysApp);
    }

    @Override
    public void del(SysAppRequest sysAppRequest) {
        SysApp sysApp = this.querySysApp(sysAppRequest);
        if (this.sysMenuService.validateMenuBindApp(CollectionUtil.set((boolean)false, (Object[])new Long[]{sysApp.getAppId()}))) {
            throw new ServiceException((AbstractExceptionEnum)SysAppExceptionEnum.APP_BIND_MENU);
        }
        this.removeById(sysApp.getAppId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(SysAppRequest sysAppRequest) {
        Set<Long> appIdList = sysAppRequest.getAppIdList();
        if (this.sysMenuService.validateMenuBindApp(appIdList)) {
            throw new ServiceException((AbstractExceptionEnum)SysAppExceptionEnum.APP_BIND_MENU);
        }
        this.removeBatchByIds(appIdList);
    }

    @Override
    public void edit(SysAppRequest sysAppRequest) {
        SysApp sysApp = this.querySysApp(sysAppRequest);
        if (!sysApp.getAppCode().equals(sysAppRequest.getAppCode())) {
            throw new ServiceException((AbstractExceptionEnum)SysAppExceptionEnum.APP_CODE_CANT_EDIT);
        }
        BeanUtil.copyProperties((Object)((Object)sysAppRequest), (Object)((Object)sysApp), (String[])new String[0]);
        this.updateById((Object)sysApp);
    }

    @Override
    public SysApp detail(SysAppRequest sysAppRequest) {
        return this.querySysApp(sysAppRequest);
    }

    @Override
    public PageResult<SysApp> findPage(SysAppRequest sysAppRequest) {
        LambdaQueryWrapper<SysApp> wrapper = this.createWrapper(sysAppRequest);
        wrapper.select(new SFunction[]{SysApp::getAppId, SysApp::getAppName, SysApp::getAppCode, SysApp::getAppIcon, SysApp::getStatusFlag, SysApp::getAppSort, BaseEntity::getCreateTime});
        Page sysAppPage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysAppPage);
    }

    @Override
    public List<AppGroupDetail> getAppList() {
        LambdaQueryWrapper<SysApp> wrapper = this.createWrapper(new SysAppRequest());
        wrapper.eq(SysApp::getStatusFlag, (Object)StatusEnum.ENABLE.getCode());
        wrapper.select(new SFunction[]{SysApp::getAppId, SysApp::getAppName, SysApp::getAppIcon, SysApp::getRemark});
        List appList = this.list((Wrapper)wrapper);
        ArrayList<AppGroupDetail> appGroupDetails = new ArrayList<AppGroupDetail>();
        for (SysApp sysApp : appList) {
            AppGroupDetail appGroupDetail = new AppGroupDetail(sysApp.getAppId(), sysApp.getAppName(), sysApp.getAppIcon(), sysApp.getRemark());
            appGroupDetails.add(appGroupDetail);
        }
        return appGroupDetails;
    }

    @Override
    public List<IndexUserAppInfo> getIndexUserAppList(Set<Long> appIds) {
        if (ObjectUtil.isEmpty(appIds)) {
            return new ArrayList<IndexUserAppInfo>();
        }
        LambdaQueryWrapper sysAppLambdaQueryWrapper = new LambdaQueryWrapper();
        sysAppLambdaQueryWrapper.in(SysApp::getAppId, appIds);
        sysAppLambdaQueryWrapper.select(new SFunction[]{SysApp::getAppId, SysApp::getAppName, SysApp::getAppIcon, SysApp::getRemark});
        sysAppLambdaQueryWrapper.orderByAsc(SysApp::getAppSort);
        List sysAppList = this.list((Wrapper)sysAppLambdaQueryWrapper);
        ArrayList<IndexUserAppInfo> indexUserAppInfos = new ArrayList<IndexUserAppInfo>();
        for (SysApp sysApp : sysAppList) {
            IndexUserAppInfo indexUserAppInfo = new IndexUserAppInfo();
            indexUserAppInfo.setAppId(sysApp.getAppId());
            indexUserAppInfo.setAppName(sysApp.getAppName());
            indexUserAppInfo.setAppIcon(sysApp.getAppIcon());
            indexUserAppInfo.setRemark(sysApp.getRemark());
            indexUserAppInfo.setCurrentSelectFlag(false);
            indexUserAppInfos.add(indexUserAppInfo);
        }
        return indexUserAppInfos;
    }

    @Override
    public List<SysApp> findList(SysAppRequest sysAppRequest) {
        LambdaQueryWrapper<SysApp> wrapper = this.createWrapper(sysAppRequest);
        wrapper.select(new SFunction[]{SysApp::getAppId, SysApp::getAppName, SysApp::getAppIcon});
        return this.list((Wrapper)wrapper);
    }

    private SysApp querySysApp(SysAppRequest sysAppRequest) {
        SysApp sysApp = (SysApp)((Object)this.getById(sysAppRequest.getAppId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysApp))) {
            throw new ServiceException((AbstractExceptionEnum)SysAppExceptionEnum.SYS_APP_NOT_EXISTED);
        }
        return sysApp;
    }

    private LambdaQueryWrapper<SysApp> createWrapper(SysAppRequest sysAppRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = sysAppRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.like(SysApp::getAppCode, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysApp::getAppName, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysApp::getRemark, (Object)searchText);
        }
        queryWrapper.orderByAsc(SysApp::getAppSort);
        return queryWrapper;
    }

    @Override
    public void updateStatus(SysAppRequest sysUserRequest) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SysApp::getStatusFlag, (Object)sysUserRequest.getStatusFlag());
        updateWrapper.eq(SysApp::getAppId, (Object)sysUserRequest.getAppId());
        this.update((Wrapper)updateWrapper);
    }
}

