/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.menu.factory;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.menu.pojo.response.AppGroupDetail;
import cn.stylefeng.roses.kernel.sys.modular.menu.pojo.response.MenuItemDetail;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MenuFactory {
    public static Set<Long> getMenuParentIds(List<SysMenu> sysMenus) {
        Set alreadyMenuIdList = sysMenus.stream().map(SysMenu::getMenuId).collect(Collectors.toSet());
        HashSet<Long> needToAddResult = new HashSet<Long>();
        for (SysMenu sysMenu : sysMenus) {
            String[] menuParentIdList;
            String menuPidsStr = sysMenu.getMenuPids();
            menuPidsStr = menuPidsStr.replaceAll("\\[", "");
            menuPidsStr = menuPidsStr.replaceAll("]", "");
            for (String parentMenuIdItem : menuParentIdList = menuPidsStr.split(",")) {
                Long menuId = Long.valueOf(parentMenuIdItem);
                if (alreadyMenuIdList.contains(menuId) || parentMenuIdItem.equals(TreeConstants.DEFAULT_PARENT_ID.toString())) continue;
                needToAddResult.add(menuId);
            }
        }
        return needToAddResult;
    }

    public static List<AppGroupDetail> createAppGroupDetailResult(List<AppGroupDetail> appGroupDetails, List<SysMenu> sysMenus) {
        Map<Long, List<SysMenu>> appIdMenuList = sysMenus.stream().collect(Collectors.groupingBy(SysMenu::getAppId));
        for (AppGroupDetail appGroupDetail : appGroupDetails) {
            Long appId = appGroupDetail.getAppId();
            List<SysMenu> appMenus = appIdMenuList.get(appId);
            if (ObjectUtil.isEmpty(appMenus)) continue;
            ArrayList<MenuItemDetail> appMenuItems = new ArrayList<MenuItemDetail>();
            for (SysMenu appMenu : appMenus) {
                MenuItemDetail menuItemDetail = new MenuItemDetail(appMenu.getMenuId(), appMenu.getMenuParentId(), appMenu.getMenuName(), appMenu.getMenuType());
                appMenuItems.add(menuItemDetail);
            }
            List menuItemDetailList = new DefaultTreeBuildFactory().doTreeBuild(appMenuItems);
            appGroupDetail.setMenuList(menuItemDetailList);
            ArrayList<Long> openMenuIdList = new ArrayList<Long>();
            if (ObjectUtil.isEmpty((Object)menuItemDetailList)) {
                appGroupDetail.setOpenMenuIdList(openMenuIdList);
                continue;
            }
            for (MenuItemDetail menuItemDetail : menuItemDetailList) {
                if (!ObjectUtil.isNotEmpty(menuItemDetail.getChildren())) continue;
                openMenuIdList.add(menuItemDetail.getMenuId());
            }
            appGroupDetail.setOpenMenuIdList(openMenuIdList);
        }
        return appGroupDetails;
    }
}

