/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.resource.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.scanner.api.ResourceReportApi;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ReportResourceParam;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.SysResourcePersistencePojo;
import cn.stylefeng.roses.kernel.sys.modular.resource.entity.SysResource;
import cn.stylefeng.roses.kernel.sys.modular.resource.factory.ResourceFactory;
import cn.stylefeng.roses.kernel.sys.modular.resource.service.SysResourceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class DefaultResourceReporter
implements ResourceReportApi {
    @Resource
    private SysResourceService sysResourceService;
    @Resource(name="resourceCache")
    private CacheOperatorApi<ResourceDefinition> resourceCache;

    @Transactional(rollbackFor={Exception.class})
    public void reportResources(@RequestBody ReportResourceParam reportResourceReq) {
        this.reportResourcesAndGetResult(reportResourceReq);
    }

    public List<SysResourcePersistencePojo> reportResourcesAndGetResult(ReportResourceParam reportResourceReq) {
        String projectCode = reportResourceReq.getProjectCode();
        Map resourceDefinitions = reportResourceReq.getResourceDefinitions();
        if (ObjectUtil.isEmpty((Object)projectCode) || resourceDefinitions == null) {
            return new ArrayList<SysResourcePersistencePojo>();
        }
        this.sysResourceService.deleteResourceByProjectCode(projectCode);
        ArrayList<SysResource> allResources = new ArrayList<SysResource>();
        ArrayList<ResourceDefinition> resourceDefinitionArrayList = new ArrayList<ResourceDefinition>();
        for (Map.Entry entry : resourceDefinitions.entrySet()) {
            Map map = (Map)entry.getValue();
            for (Map.Entry modularResources : map.entrySet()) {
                resourceDefinitionArrayList.add((ResourceDefinition)modularResources.getValue());
                SysResource resource = ResourceFactory.createResource((ResourceDefinition)modularResources.getValue());
                allResources.add(resource);
            }
        }
        this.sysResourceService.batchSaveResourceList(allResources);
        Map<String, ResourceDefinition> resourceDefinitionMap = ResourceFactory.orderedResourceDefinition(resourceDefinitionArrayList);
        for (Map.Entry<String, ResourceDefinition> entry : resourceDefinitionMap.entrySet()) {
            this.resourceCache.put(entry.getKey(), (Object)entry.getValue());
        }
        ArrayList<SysResourcePersistencePojo> arrayList = new ArrayList<SysResourcePersistencePojo>();
        for (SysResource item : allResources) {
            SysResourcePersistencePojo sysResourcePersistencePojo = new SysResourcePersistencePojo();
            BeanUtil.copyProperties((Object)((Object)item), (Object)sysResourcePersistencePojo, (String[])new String[0]);
            arrayList.add(sysResourcePersistencePojo);
        }
        return arrayList;
    }
}

