/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleAssignOperateAction;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleBindLimitAction;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleLimit;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenu;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.PermissionNodeTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.RoleLimitTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.RoleBindPermissionRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleLimitService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.util.AssertAssignUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RoleBindMenuImpl
implements RoleAssignOperateAction,
RoleBindLimitAction {
    @Resource
    private SysRoleMenuService sysRoleMenuService;
    @Resource
    private SysMenuOptionsService sysMenuOptionsService;
    @Resource
    private SysRoleMenuOptionsService sysRoleMenuOptionsService;
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysRoleLimitService sysRoleLimitService;

    @Override
    public PermissionNodeTypeEnum getNodeType() {
        return PermissionNodeTypeEnum.MENU;
    }

    @Override
    public void doOperateAction(RoleBindPermissionRequest roleBindPermissionRequest, Set<Long> roleLimitMenuIdsAndOptionIds) {
        List<Long> menuOptions;
        Long roleId = roleBindPermissionRequest.getRoleId();
        Long menuId = roleBindPermissionRequest.getNodeId();
        if (ObjectUtil.isNotEmpty(roleLimitMenuIdsAndOptionIds) && !roleLimitMenuIdsAndOptionIds.contains(menuId)) {
            return;
        }
        LambdaQueryWrapper sysRoleMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuLambdaQueryWrapper.eq(SysRoleMenu::getMenuId, (Object)menuId);
        sysRoleMenuLambdaQueryWrapper.eq(SysRoleMenu::getRoleId, (Object)roleId);
        this.sysRoleMenuService.remove((Wrapper)sysRoleMenuLambdaQueryWrapper);
        Map menuAppIdMap = this.sysMenuService.getMenuAppId(ListUtil.list((boolean)false, (Object[])new Long[]{menuId}));
        Long appId = (Long)menuAppIdMap.get(menuId);
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            SysRoleMenu sysRoleMenu = new SysRoleMenu();
            sysRoleMenu.setRoleId(roleId);
            sysRoleMenu.setMenuId(menuId);
            sysRoleMenu.setAppId(appId);
            this.sysRoleMenuService.save((Object)sysRoleMenu);
        }
        if (ObjectUtil.isEmpty(menuOptions = this.getMenuOptions(menuId, roleLimitMenuIdsAndOptionIds))) {
            return;
        }
        LambdaQueryWrapper roleMenuOptionsLambdaQueryWrapper = new LambdaQueryWrapper();
        roleMenuOptionsLambdaQueryWrapper.eq(SysRoleMenuOptions::getRoleId, (Object)roleId);
        roleMenuOptionsLambdaQueryWrapper.in(SysRoleMenuOptions::getMenuOptionId, menuOptions);
        AssertAssignUtil.assertAssign(roleId, (LambdaQueryWrapper<SysRoleMenuOptions>)roleMenuOptionsLambdaQueryWrapper);
        this.sysRoleMenuOptionsService.remove((Wrapper)roleMenuOptionsLambdaQueryWrapper);
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            ArrayList<SysRoleMenuOptions> sysRoleMenuOptions = new ArrayList<SysRoleMenuOptions>();
            for (Long menuOptionId : menuOptions) {
                SysRoleMenuOptions roleMenuOptions = new SysRoleMenuOptions();
                roleMenuOptions.setRoleId(roleId);
                roleMenuOptions.setAppId(appId);
                roleMenuOptions.setMenuId(menuId);
                roleMenuOptions.setMenuOptionId(menuOptionId);
                sysRoleMenuOptions.add(roleMenuOptions);
            }
            this.sysRoleMenuOptionsService.saveBatch(sysRoleMenuOptions);
        }
    }

    @Override
    public PermissionNodeTypeEnum getRoleBindLimitNodeType() {
        return this.getNodeType();
    }

    @Override
    public void doRoleBindLimitAction(RoleBindPermissionRequest roleBindPermissionRequest) {
        List<Long> menuOptionsIds;
        Long roleId = roleBindPermissionRequest.getRoleId();
        Long menuId = roleBindPermissionRequest.getNodeId();
        ArrayList<SysRoleLimit> sysRoleLimitTotal = new ArrayList<SysRoleLimit>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysRoleLimit::getRoleId, (Object)roleId);
        wrapper.eq(SysRoleLimit::getBusinessId, (Object)menuId);
        this.sysRoleLimitService.remove((Wrapper)wrapper);
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            SysRoleLimit sysRoleLimit = new SysRoleLimit();
            sysRoleLimit.setRoleId(roleId);
            sysRoleLimit.setLimitType(RoleLimitTypeEnum.MENU.getCode());
            sysRoleLimit.setBusinessId(menuId);
            sysRoleLimitTotal.add(sysRoleLimit);
        }
        if (ObjectUtil.isEmpty(menuOptionsIds = this.getMenuOptions(menuId))) {
            this.sysRoleLimitService.saveBatch(sysRoleLimitTotal);
            return;
        }
        LambdaQueryWrapper optionWrapper = new LambdaQueryWrapper();
        optionWrapper.eq(SysRoleLimit::getRoleId, (Object)roleId);
        optionWrapper.in(SysRoleLimit::getBusinessId, menuOptionsIds);
        this.sysRoleLimitService.remove((Wrapper)optionWrapper);
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            for (Long menuOptionId : menuOptionsIds) {
                SysRoleLimit sysRoleLimit = new SysRoleLimit();
                sysRoleLimit.setRoleId(roleId);
                sysRoleLimit.setLimitType(RoleLimitTypeEnum.MENU_OPTIONS.getCode());
                sysRoleLimit.setBusinessId(menuOptionId);
                sysRoleLimitTotal.add(sysRoleLimit);
            }
        }
        this.sysRoleLimitService.saveBatch(sysRoleLimitTotal);
    }

    private List<Long> getMenuOptions(Long menuId) {
        return this.getMenuOptions(menuId, null);
    }

    private List<Long> getMenuOptions(Long menuId, Set<Long> roleLimitMenuIdsAndOptionIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMenuOptions::getMenuId, (Object)menuId);
        if (ObjectUtil.isNotEmpty(roleLimitMenuIdsAndOptionIds)) {
            queryWrapper.in(SysMenuOptions::getMenuOptionId, roleLimitMenuIdsAndOptionIds);
        }
        queryWrapper.select(new SFunction[]{SysMenuOptions::getMenuOptionId});
        List list = this.sysMenuOptionsService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)list)) {
            return new ArrayList<Long>();
        }
        return list.stream().map(SysMenuOptions::getMenuOptionId).collect(Collectors.toList());
    }
}

