/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.sys.api.SysUserRoleServiceApi;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleAssignOperateAction;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleBindLimitAction;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleLimit;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.PermissionNodeTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.RoleLimitTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.RoleBindPermissionRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleLimitService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.role.util.AssertAssignUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RoleBindOptionImpl
implements RoleAssignOperateAction,
RoleBindLimitAction {
    @Resource
    private SysRoleMenuOptionsService sysRoleMenuOptionsService;
    @Resource
    private SysRoleLimitService sysRoleLimitService;
    @Resource
    private SysUserRoleServiceApi sysUserRoleServiceApi;

    @Override
    public PermissionNodeTypeEnum getNodeType() {
        return PermissionNodeTypeEnum.OPTIONS;
    }

    @Override
    public void doOperateAction(RoleBindPermissionRequest roleBindPermissionRequest, Set<Long> roleLimitMenuIdsAndOptionIds) {
        Long roleId = roleBindPermissionRequest.getRoleId();
        Long menuOptionId = roleBindPermissionRequest.getNodeId();
        if (ObjectUtil.isNotEmpty(roleLimitMenuIdsAndOptionIds) && !roleLimitMenuIdsAndOptionIds.contains(menuOptionId)) {
            return;
        }
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            SysRoleMenuOptions sysRoleMenuOptions = new SysRoleMenuOptions();
            sysRoleMenuOptions.setRoleId(roleId);
            sysRoleMenuOptions.setMenuOptionId(menuOptionId);
            this.sysRoleMenuOptionsService.save((Object)sysRoleMenuOptions);
        } else {
            Long userId = LoginContext.me().getLoginUser().getUserId();
            List userRoleIdList = this.sysUserRoleServiceApi.getUserRoleIdList(userId);
            if (userRoleIdList.contains(roleId) && menuOptionId.equals(AssertAssignUtil.DISABLED_MENU_OPTIONS)) {
                return;
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(SysRoleMenuOptions::getRoleId, (Object)roleId);
            wrapper.eq(SysRoleMenuOptions::getMenuOptionId, (Object)menuOptionId);
            this.sysRoleMenuOptionsService.remove((Wrapper)wrapper);
        }
    }

    @Override
    public PermissionNodeTypeEnum getRoleBindLimitNodeType() {
        return this.getNodeType();
    }

    @Override
    public void doRoleBindLimitAction(RoleBindPermissionRequest roleBindPermissionRequest) {
        Long roleId = roleBindPermissionRequest.getRoleId();
        Long menuOptionId = roleBindPermissionRequest.getNodeId();
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            SysRoleLimit sysRoleLimit = new SysRoleLimit();
            sysRoleLimit.setRoleId(roleId);
            sysRoleLimit.setLimitType(RoleLimitTypeEnum.MENU_OPTIONS.getCode());
            sysRoleLimit.setBusinessId(menuOptionId);
            this.sysRoleLimitService.save((Object)sysRoleLimit);
        } else {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(SysRoleLimit::getRoleId, (Object)roleId);
            wrapper.eq(SysRoleLimit::getBusinessId, (Object)menuOptionId);
            this.sysRoleLimitService.remove((Wrapper)wrapper);
        }
    }
}

