/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.util.BusinessLogUtil;
import cn.stylefeng.roses.kernel.rule.enums.permission.DataScopeTypeEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveRoleCallbackApi;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleDataScope;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.exception.SysRoleDataScopeExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.mapper.SysRoleDataScopeMapper;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.RoleBindDataScopeRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.SysRoleDataScopeRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.response.RoleBindDataScopeResponse;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleDataScopeService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleDataScopeServiceImpl
extends ServiceImpl<SysRoleDataScopeMapper, SysRoleDataScope>
implements SysRoleDataScopeService,
RemoveRoleCallbackApi {
    @Resource
    private SysRoleService sysRoleService;

    @Override
    public void add(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        SysRoleDataScope sysRoleDataScope = new SysRoleDataScope();
        BeanUtil.copyProperties((Object)((Object)sysRoleDataScopeRequest), (Object)((Object)sysRoleDataScope), (String[])new String[0]);
        this.save((Object)sysRoleDataScope);
    }

    @Override
    public void del(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        SysRoleDataScope sysRoleDataScope = this.querySysRoleDataScope(sysRoleDataScopeRequest);
        this.removeById(sysRoleDataScope.getRoleDataScopeId());
    }

    @Override
    public void edit(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        SysRoleDataScope sysRoleDataScope = this.querySysRoleDataScope(sysRoleDataScopeRequest);
        BeanUtil.copyProperties((Object)((Object)sysRoleDataScopeRequest), (Object)((Object)sysRoleDataScope), (String[])new String[0]);
        this.updateById((Object)sysRoleDataScope);
    }

    @Override
    public SysRoleDataScope detail(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        return this.querySysRoleDataScope(sysRoleDataScopeRequest);
    }

    @Override
    public PageResult<SysRoleDataScope> findPage(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        LambdaQueryWrapper<SysRoleDataScope> wrapper = this.createWrapper(sysRoleDataScopeRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public List<SysRoleDataScope> findList(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        LambdaQueryWrapper<SysRoleDataScope> wrapper = this.createWrapper(sysRoleDataScopeRequest);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public RoleBindDataScopeResponse getRoleBindDataScope(RoleBindDataScopeRequest roleBindDataScopeRequest) {
        RoleBindDataScopeResponse roleBindDataScopeResponse = new RoleBindDataScopeResponse();
        roleBindDataScopeResponse.setOrgIdList(new ArrayList<Long>());
        Integer dataScopeType = this.sysRoleService.getRoleDataScopeType(roleBindDataScopeRequest.getRoleId());
        roleBindDataScopeResponse.setDataScopeType(dataScopeType);
        if (!DataScopeTypeEnum.DEFINE.getCode().equals(dataScopeType)) {
            return roleBindDataScopeResponse;
        }
        Set<Long> roleBindOrgIdList = this.getRoleBindOrgIdList(ListUtil.list((boolean)false, (Object[])new Long[]{roleBindDataScopeRequest.getRoleId()}));
        roleBindDataScopeResponse.setOrgIdList(CollectionUtil.list((boolean)false, roleBindOrgIdList));
        return roleBindDataScopeResponse;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRoleBindDataScope(RoleBindDataScopeRequest roleBindDataScopeRequest) {
        BusinessLogUtil.setLogTitle((String)"\u4fee\u6539\u89d2\u8272\u6570\u636e\u8303\u56f4", (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u89d2\u8272\u7ed1\u5b9a\u6570\u636e\u8303\u56f4\u7684\u53c2\u6570\u5982\u4e0b\uff1a\n", roleBindDataScopeRequest});
        LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
        removeWrapper.eq(SysRoleDataScope::getRoleId, (Object)roleBindDataScopeRequest.getRoleId());
        this.remove((Wrapper)removeWrapper);
        Integer dataScopeType = roleBindDataScopeRequest.getDataScopeType();
        this.sysRoleService.updateRoleDataScopeType(roleBindDataScopeRequest.getRoleId(), dataScopeType);
        if (!DataScopeTypeEnum.DEFINE.getCode().equals(dataScopeType)) {
            return;
        }
        List<Long> orgIdList = roleBindDataScopeRequest.getOrgIdList();
        if (ObjectUtil.isEmpty(orgIdList)) {
            return;
        }
        ArrayList<SysRoleDataScope> bindRoleDataScopeList = new ArrayList<SysRoleDataScope>();
        for (Long orgId : orgIdList) {
            SysRoleDataScope sysRoleDataScope = new SysRoleDataScope();
            sysRoleDataScope.setRoleId(roleBindDataScopeRequest.getRoleId());
            sysRoleDataScope.setOrganizationId(orgId);
            bindRoleDataScopeList.add(sysRoleDataScope);
        }
        this.saveBatch(bindRoleDataScopeList);
    }

    @Override
    public Set<Long> getRoleBindOrgIdList(List<Long> roleIdList) {
        if (ObjectUtil.isEmpty(roleIdList)) {
            return new HashSet<Long>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysRoleDataScope::getRoleId, roleIdList);
        wrapper.select(new SFunction[]{SysRoleDataScope::getOrganizationId});
        List sysRoleDataScopes = this.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)sysRoleDataScopes)) {
            return sysRoleDataScopes.stream().map(SysRoleDataScope::getOrganizationId).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }

    public void validateHaveRoleBind(Set<Long> beRemovedRoleIdList) {
    }

    public void removeRoleAction(Set<Long> beRemovedRoleIdList) {
        LambdaQueryWrapper sysRoleDataScopeLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleDataScopeLambdaQueryWrapper.in(SysRoleDataScope::getRoleId, beRemovedRoleIdList);
        this.remove((Wrapper)sysRoleDataScopeLambdaQueryWrapper);
    }

    private SysRoleDataScope querySysRoleDataScope(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        SysRoleDataScope sysRoleDataScope = (SysRoleDataScope)((Object)this.getById(sysRoleDataScopeRequest.getRoleDataScopeId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysRoleDataScope))) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleDataScopeExceptionEnum.SYS_ROLE_DATA_SCOPE_NOT_EXISTED);
        }
        return sysRoleDataScope;
    }

    private LambdaQueryWrapper<SysRoleDataScope> createWrapper(SysRoleDataScopeRequest sysRoleDataScopeRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long roleId = sysRoleDataScopeRequest.getRoleId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)roleId), SysRoleDataScope::getRoleId, (Object)roleId);
        return queryWrapper;
    }
}

