/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.dsctn.api.context.DataSourceContext;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveMenuCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveRoleCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.constants.SysConstants;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenu;
import cn.stylefeng.roses.kernel.sys.modular.role.mapper.SysRoleMenuMapper;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysRoleMenuServiceImpl
extends ServiceImpl<SysRoleMenuMapper, SysRoleMenu>
implements SysRoleMenuService,
RemoveRoleCallbackApi,
RemoveMenuCallbackApi {
    @Resource(name="roleMenuCache")
    private CacheOperatorApi<List<Long>> roleMenuCache;

    @Override
    public void bindRoleMenus(Long roleId, List<SysMenu> menuList) {
        if (ObjectUtil.isEmpty((Object)roleId) || ObjectUtil.isEmpty(menuList)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleMenu::getRoleId, (Object)roleId);
        this.remove((Wrapper)queryWrapper);
        ArrayList<SysRoleMenu> sysRoleMenus = new ArrayList<SysRoleMenu>();
        for (SysMenu sysMenu : menuList) {
            SysRoleMenu sysRoleMenu = new SysRoleMenu();
            sysRoleMenu.setRoleId(roleId);
            sysRoleMenu.setAppId(sysMenu.getAppId());
            sysRoleMenu.setMenuId(sysMenu.getMenuId());
            sysRoleMenus.add(sysRoleMenu);
        }
        if (DbTypeEnum.MYSQL.equals((Object)DataSourceContext.me().getCurrentDbType())) {
            ((SysRoleMenuMapper)this.getBaseMapper()).insertBatchSomeColumn(sysRoleMenus);
        } else {
            this.saveBatch(sysRoleMenus);
        }
        this.roleMenuCache.remove(new String[]{String.valueOf(roleId)});
    }

    @Override
    public List<Long> getRoleBindMenuIdList(List<Long> roleIdList) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (ObjectUtil.isEmpty(roleIdList)) {
            return result;
        }
        for (Long roleId : roleIdList) {
            String roleIdKey = String.valueOf(roleId);
            List cacheMenuIdList = (List)this.roleMenuCache.get(roleIdKey);
            if (ObjectUtil.isNotEmpty((Object)cacheMenuIdList)) {
                result.addAll(cacheMenuIdList);
                continue;
            }
            LambdaQueryWrapper sysRoleMenuLambdaQueryWrapper = new LambdaQueryWrapper();
            sysRoleMenuLambdaQueryWrapper.eq(SysRoleMenu::getRoleId, (Object)roleId);
            sysRoleMenuLambdaQueryWrapper.select(new SFunction[]{SysRoleMenu::getMenuId});
            List sysRoleMenuList = this.list((Wrapper)sysRoleMenuLambdaQueryWrapper);
            if (!ObjectUtil.isNotEmpty((Object)sysRoleMenuList)) continue;
            List menuIdListQueryResult = sysRoleMenuList.stream().map(SysRoleMenu::getMenuId).collect(Collectors.toList());
            result.addAll(menuIdListQueryResult);
            this.roleMenuCache.put(roleIdKey, menuIdListQueryResult, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
        }
        return result;
    }

    @Override
    public boolean validateRoleHaveAppIdPermission(List<Long> roleIdList, Long appId) {
        LambdaQueryWrapper sysRoleMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuLambdaQueryWrapper.in(SysRoleMenu::getRoleId, roleIdList);
        sysRoleMenuLambdaQueryWrapper.eq(SysRoleMenu::getAppId, (Object)appId);
        return this.count((Wrapper)sysRoleMenuLambdaQueryWrapper) > 0L;
    }

    public void validateHaveRoleBind(Set<Long> beRemovedRoleIdList) {
    }

    public void removeRoleAction(Set<Long> beRemovedRoleIdList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysRoleMenu::getRoleId, beRemovedRoleIdList);
        this.remove((Wrapper)wrapper);
    }

    public void removeMenuAction(Set<Long> beRemovedMenuIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleMenu::getMenuId, beRemovedMenuIdList);
        this.remove((Wrapper)queryWrapper);
    }
}

