/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.notice.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.sys.api.MessagePublishApi;
import cn.stylefeng.roses.kernel.sys.api.SysUserOrgServiceApi;
import cn.stylefeng.roses.kernel.sys.api.enums.message.MessageBusinessTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.enums.notice.NoticePublishStatusEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.message.MessageRetractDTO;
import cn.stylefeng.roses.kernel.sys.modular.notice.entity.SysNotice;
import cn.stylefeng.roses.kernel.sys.modular.notice.enums.SysNoticeExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.notice.factory.NoticeFactory;
import cn.stylefeng.roses.kernel.sys.modular.notice.mapper.SysNoticeMapper;
import cn.stylefeng.roses.kernel.sys.modular.notice.pojo.NoticeUserScope;
import cn.stylefeng.roses.kernel.sys.modular.notice.pojo.request.SysNoticeRequest;
import cn.stylefeng.roses.kernel.sys.modular.notice.service.SysNoticeService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysNoticeServiceImpl
extends ServiceImpl<SysNoticeMapper, SysNotice>
implements SysNoticeService {
    @Resource
    private MessagePublishApi messagePublishApi;
    @Resource
    private SysUserOrgServiceApi sysUserOrgServiceApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SysNoticeRequest sysNoticeRequest) {
        this.validateUserScope(sysNoticeRequest);
        SysNotice sysNotice = new SysNotice();
        BeanUtil.copyProperties((Object)((Object)sysNoticeRequest), (Object)((Object)sysNotice), (String[])new String[0]);
        sysNotice.setPublishStatus(NoticePublishStatusEnum.NOT_PUBLISH.getCode());
        this.save((Object)sysNotice);
    }

    @Override
    public void del(SysNoticeRequest sysNoticeRequest) {
        SysNotice sysNotice = this.querySysNotice(sysNoticeRequest);
        this.removeById(sysNotice.getNoticeId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(SysNoticeRequest sysNoticeRequest) {
        this.removeByIds(sysNoticeRequest.getBatchDeleteIdList());
    }

    @Override
    public void edit(SysNoticeRequest sysNoticeRequest) {
        this.validateUserScope(sysNoticeRequest);
        SysNotice sysNotice = this.querySysNotice(sysNoticeRequest);
        if (sysNotice == null) {
            throw new ServiceException((AbstractExceptionEnum)SysNoticeExceptionEnum.SYS_NOTICE_NOT_EXISTED);
        }
        if (NoticePublishStatusEnum.ALREADY.getCode().equals(sysNotice.getPublishStatus())) {
            throw new ServiceException((AbstractExceptionEnum)SysNoticeExceptionEnum.SYS_NOTICE_CANT_EDIT);
        }
        BeanUtil.copyProperties((Object)((Object)sysNoticeRequest), (Object)((Object)sysNotice), (String[])new String[0]);
        this.updateById((Object)sysNotice);
    }

    @Override
    public SysNotice detail(SysNoticeRequest sysNoticeRequest) {
        return this.querySysNotice(sysNoticeRequest);
    }

    @Override
    public PageResult<SysNotice> findPage(SysNoticeRequest sysNoticeRequest) {
        LambdaQueryWrapper<SysNotice> wrapper = this.createWrapper(sysNoticeRequest);
        wrapper.select(new SFunction[]{SysNotice::getNoticeId, SysNotice::getNoticeTitle, SysNotice::getPublishStatus, SysNotice::getPriorityLevel, SysNotice::getNoticeBeginTime, SysNotice::getNoticeEndTime, BaseEntity::getCreateUser, BaseEntity::getCreateTime});
        Page pageList = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)pageList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void publishNotice(SysNoticeRequest sysNoticeRequest) {
        SysNotice sysNotice = this.querySysNotice(sysNoticeRequest);
        sysNotice.setPublishStatus(NoticePublishStatusEnum.ALREADY.getCode());
        this.updateById((Object)sysNotice);
        NoticeUserScope noticeUserScope = sysNotice.getNoticeUserScope();
        Set<Long> noticeUserList = this.getNoticeUserList(noticeUserScope);
        this.messagePublishApi.batchSendMessage(NoticeFactory.createMessageSendDTO(noticeUserList, sysNotice));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void retractNotice(SysNoticeRequest sysNoticeRequest) {
        SysNotice sysNotice = this.querySysNotice(sysNoticeRequest);
        sysNotice.setPublishStatus(NoticePublishStatusEnum.NOT_PUBLISH.getCode());
        this.updateById((Object)sysNotice);
        MessageRetractDTO messageRetractDTO = new MessageRetractDTO();
        messageRetractDTO.setBusinessType(MessageBusinessTypeEnum.SYS_NOTICE.getCode());
        messageRetractDTO.setBusinessId(String.valueOf(sysNotice.getNoticeId()));
        this.messagePublishApi.batchRetractMessage(messageRetractDTO);
    }

    @Override
    public List<SysNotice> findList(SysNoticeRequest sysNoticeRequest) {
        LambdaQueryWrapper<SysNotice> wrapper = this.createWrapper(sysNoticeRequest);
        return this.list((Wrapper)wrapper);
    }

    private SysNotice querySysNotice(SysNoticeRequest sysNoticeRequest) {
        SysNotice sysNotice = (SysNotice)((Object)this.getById(sysNoticeRequest.getNoticeId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysNotice))) {
            throw new ServiceException((AbstractExceptionEnum)SysNoticeExceptionEnum.SYS_NOTICE_NOT_EXISTED);
        }
        return sysNotice;
    }

    private LambdaQueryWrapper<SysNotice> createWrapper(SysNoticeRequest sysNoticeRequest) {
        String priorityLevel;
        Integer publishStatus;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = sysNoticeRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.like(SysNotice::getNoticeTitle, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(SysNotice::getNoticeContent, (Object)searchText);
        }
        if (ObjectUtil.isNotEmpty((Object)(publishStatus = sysNoticeRequest.getPublishStatus()))) {
            queryWrapper.nested(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.eq(SysNotice::getPublishStatus, (Object)publishStatus);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)(priorityLevel = sysNoticeRequest.getPriorityLevel()))) {
            queryWrapper.nested(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.eq(SysNotice::getPriorityLevel, (Object)priorityLevel);
            });
        }
        return queryWrapper;
    }

    private void validateUserScope(SysNoticeRequest sysNoticeRequest) {
        NoticeUserScope noticeUserScope = sysNoticeRequest.getNoticeUserScope();
        if (noticeUserScope == null) {
            throw new ServiceException((AbstractExceptionEnum)SysNoticeExceptionEnum.SYS_NOTICE_SCOPE_EMPTY);
        }
        if (ObjectUtil.isEmpty(noticeUserScope.getPointOrgList()) && ObjectUtil.isEmpty(noticeUserScope.getPointUserList())) {
            throw new ServiceException((AbstractExceptionEnum)SysNoticeExceptionEnum.SYS_NOTICE_SCOPE_EMPTY);
        }
    }

    private Set<Long> getNoticeUserList(NoticeUserScope noticeUserScope) {
        Set orgUserIdList;
        List<SimpleDict> pointOrgList;
        LinkedHashSet<Long> userIdCollection = new LinkedHashSet<Long>();
        List<SimpleDict> pointUserList = noticeUserScope.getPointUserList();
        if (ObjectUtil.isNotEmpty(pointUserList)) {
            userIdCollection.addAll(pointUserList.stream().map(SimpleDict::getId).collect(Collectors.toList()));
        }
        if (ObjectUtil.isNotEmpty(pointOrgList = noticeUserScope.getPointOrgList()) && ObjectUtil.isNotEmpty((Object)(orgUserIdList = this.sysUserOrgServiceApi.getOrgUserIdList(pointOrgList.stream().map(SimpleDict::getId).collect(Collectors.toSet()))))) {
            userIdCollection.addAll(orgUserIdList);
        }
        return userIdCollection;
    }
}

