/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.theme.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.exception.SysException;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysThemeTemplate;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysThemeTemplateRel;
import cn.stylefeng.roses.kernel.sys.modular.theme.exceptions.SysThemeTemplateExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.theme.mapper.SysThemeTemplateRelMapper;
import cn.stylefeng.roses.kernel.sys.modular.theme.pojo.SysThemeTemplateRelRequest;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeTemplateRelService;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeTemplateService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysThemeTemplateRelServiceImpl
extends ServiceImpl<SysThemeTemplateRelMapper, SysThemeTemplateRel>
implements SysThemeTemplateRelService {
    @Resource
    private SysThemeTemplateService sysThemeTemplateService;

    @Override
    public void add(SysThemeTemplateRelRequest sysThemeTemplateRelRequest) {
        this.checkTemplateStatus(sysThemeTemplateRelRequest);
        String[] fieldCodes = sysThemeTemplateRelRequest.getFieldCodes();
        ArrayList<SysThemeTemplateRel> sysThemeTemplateRels = new ArrayList<SysThemeTemplateRel>();
        for (String fieldCode : fieldCodes) {
            SysThemeTemplateRel sysThemeTemplateRel = new SysThemeTemplateRel();
            sysThemeTemplateRel.setTemplateId(sysThemeTemplateRelRequest.getTemplateId());
            sysThemeTemplateRel.setFieldCode(fieldCode);
            sysThemeTemplateRels.add(sysThemeTemplateRel);
        }
        this.saveBatch(sysThemeTemplateRels);
    }

    private void checkTemplateStatus(SysThemeTemplateRelRequest sysThemeTemplateRelRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThemeTemplate::getTemplateId, (Object)sysThemeTemplateRelRequest.getTemplateId());
        SysThemeTemplate sysThemeTemplate = (SysThemeTemplate)((Object)this.sysThemeTemplateService.getOne((Wrapper)queryWrapper, true));
        if (YesOrNotEnum.Y.getCode().equals(sysThemeTemplate.getStatusFlag().toString())) {
            throw new SysException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_IS_USED);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysThemeTemplateRelRequest sysThemeTemplateRelRequest) {
        this.checkTemplateStatus(sysThemeTemplateRelRequest);
        Object[] fieldCodes = sysThemeTemplateRelRequest.getFieldCodes();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysThemeTemplateRel::getFieldCode, fieldCodes);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getThemeTemplateFieldCodeList(Long templateId) {
        if (ObjectUtil.isEmpty((Object)templateId)) {
            return new ArrayList<String>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThemeTemplateRel::getTemplateId, (Object)templateId);
        queryWrapper.select(new SFunction[]{SysThemeTemplateRel::getFieldCode});
        List list = this.list((Wrapper)queryWrapper);
        return list.stream().map(SysThemeTemplateRel::getFieldCode).collect(Collectors.toList());
    }
}

