/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.AliasDefinition;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ComponentTemplateSummary
implements JsonpSerializable {
    private final Map<String, JsonData> meta;
    @Nullable
    private final Long version;
    private final Map<String, IndexSettings> settings;
    @Nullable
    private final TypeMapping mappings;
    private final Map<String, AliasDefinition> aliases;
    public static final JsonpDeserializer<ComponentTemplateSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ComponentTemplateSummary::setupComponentTemplateSummaryDeserializer);

    private ComponentTemplateSummary(Builder builder) {
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.version = builder.version;
        this.settings = ApiTypeHelper.unmodifiableRequired(builder.settings, (Object)this, "settings");
        this.mappings = builder.mappings;
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
    }

    public static ComponentTemplateSummary of(Function<Builder, ObjectBuilder<ComponentTemplateSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    public final Map<String, IndexSettings> settings() {
        return this.settings;
    }

    @Nullable
    public final TypeMapping mappings() {
        return this.mappings;
    }

    public final Map<String, AliasDefinition> aliases() {
        return this.aliases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (ApiTypeHelper.isDefined(this.settings)) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.settings.entrySet()) {
                generator.writeKey(entry.getKey());
                ((IndexSettings)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.aliases.entrySet()) {
                generator.writeKey(entry.getKey());
                ((AliasDefinition)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupComponentTemplateSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(IndexSettings._DESERIALIZER), "settings");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(AliasDefinition._DESERIALIZER), "aliases");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ComponentTemplateSummary> {
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Long version;
        private Map<String, IndexSettings> settings;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private Map<String, AliasDefinition> aliases;

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder settings(Map<String, IndexSettings> map) {
            this.settings = Builder._mapPutAll(this.settings, map);
            return this;
        }

        public final Builder settings(String key, IndexSettings value) {
            this.settings = Builder._mapPut(this.settings, key, value);
            return this;
        }

        public final Builder settings(String key, Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(key, fn.apply(new IndexSettings.Builder()).build());
        }

        public final Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder aliases(Map<String, AliasDefinition> map) {
            this.aliases = Builder._mapPutAll(this.aliases, map);
            return this;
        }

        public final Builder aliases(String key, AliasDefinition value) {
            this.aliases = Builder._mapPut(this.aliases, key, value);
            return this;
        }

        public final Builder aliases(String key, Function<AliasDefinition.Builder, ObjectBuilder<AliasDefinition>> fn) {
            return this.aliases(key, fn.apply(new AliasDefinition.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ComponentTemplateSummary build() {
            this._checkSingleUse();
            return new ComponentTemplateSummary(this);
        }
    }
}

