/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PointInTimeReference
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final Time keepAlive;
    public static final JsonpDeserializer<PointInTimeReference> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PointInTimeReference::setupPointInTimeReferenceDeserializer);

    private PointInTimeReference(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.keepAlive = builder.keepAlive;
    }

    public static PointInTimeReference of(Function<Builder, ObjectBuilder<PointInTimeReference>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time keepAlive() {
        return this.keepAlive;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        if (this.keepAlive != null) {
            generator.writeKey("keep_alive");
            this.keepAlive.serialize(generator, mapper);
        }
    }

    protected static void setupPointInTimeReferenceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::keepAlive, Time._DESERIALIZER, "keep_alive");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PointInTimeReference> {
        private String id;
        @Nullable
        private Time keepAlive;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder keepAlive(@Nullable Time value) {
            this.keepAlive = value;
            return this;
        }

        public final Builder keepAlive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.keepAlive(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PointInTimeReference build() {
            this._checkSingleUse();
            return new PointInTimeReference(this);
        }
    }
}

