/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.get_api_key.ApiKey;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetApiKeyResponse
implements JsonpSerializable {
    private final List<ApiKey> apiKeys;
    public static final JsonpDeserializer<GetApiKeyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetApiKeyResponse::setupGetApiKeyResponseDeserializer);

    private GetApiKeyResponse(Builder builder) {
        this.apiKeys = ApiTypeHelper.unmodifiableRequired(builder.apiKeys, (Object)this, "apiKeys");
    }

    public static GetApiKeyResponse of(Function<Builder, ObjectBuilder<GetApiKeyResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ApiKey> apiKeys() {
        return this.apiKeys;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.apiKeys)) {
            generator.writeKey("api_keys");
            generator.writeStartArray();
            for (ApiKey item0 : this.apiKeys) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetApiKeyResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKeys, JsonpDeserializer.arrayDeserializer(ApiKey._DESERIALIZER), "api_keys");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetApiKeyResponse> {
        private List<ApiKey> apiKeys;

        public final Builder apiKeys(List<ApiKey> list) {
            this.apiKeys = Builder._listAddAll(this.apiKeys, list);
            return this;
        }

        public final Builder apiKeys(ApiKey value, ApiKey ... values) {
            this.apiKeys = Builder._listAdd(this.apiKeys, value, values);
            return this;
        }

        public final Builder apiKeys(Function<ApiKey.Builder, ObjectBuilder<ApiKey>> fn) {
            return this.apiKeys(fn.apply(new ApiKey.Builder()).build(), new ApiKey[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetApiKeyResponse build() {
            this._checkSingleUse();
            return new GetApiKeyResponse(this);
        }
    }
}

