/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.env;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="dubbo.cloud")
public class DubboCloudProperties {
    public static final String ALL_DUBBO_SERVICES = "*";
    private String subscribedServices = "*";
    private int retryCount = 5;
    private int interval = 10000;

    public String getSubscribedServices() {
        return this.subscribedServices;
    }

    public void setSubscribedServices(String subscribedServices) {
        this.subscribedServices = subscribedServices;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public Set<String> subscribedServices() {
        String[] services = StringUtils.commaDelimitedListToStringArray((String)this.getSubscribedServices());
        if (services.length < 1) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> subscribedServices = new LinkedHashSet<String>();
        for (String service : services) {
            if (!StringUtils.hasText((String)service)) continue;
            subscribedServices.add(StringUtils.trimAllWhitespace((String)service));
        }
        return Collections.unmodifiableSet(subscribedServices);
    }
}

