/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.service;

import com.alibaba.cloud.dubbo.env.DubboCloudProperties;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceFactory;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DubboMetadataServiceInvocationHandler
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GenericService genericService;
    private final DubboCloudProperties dubboCloudProperties;

    DubboMetadataServiceInvocationHandler(String serviceName, String version, DubboGenericServiceFactory dubboGenericServiceFactory, DubboCloudProperties dubboCloudProperties) {
        this.dubboCloudProperties = dubboCloudProperties;
        this.genericService = dubboGenericServiceFactory.create(serviceName, DubboMetadataService.class, version);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue = null;
        for (int i = 1; i <= this.dubboCloudProperties.getRetryCount(); ++i) {
            try {
                returnValue = this.genericService.$invoke(method.getName(), this.getParameterTypes(method), args);
                continue;
            }
            catch (Throwable e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("[failed " + i + " times] " + e.getMessage(), e);
                }
                Thread.sleep(this.dubboCloudProperties.getInterval() * i);
            }
        }
        return returnValue;
    }

    private String[] getParameterTypes(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return (String[])Stream.of(parameterTypes).map(Class::getName).toArray(String[]::new);
    }
}

