/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public abstract class AbstractNacosDataParser {
    protected static final String DOT = ".";
    protected static final String VALUE = "value";
    protected static final String EMPTY_STRING = "";
    private String extension;
    private AbstractNacosDataParser nextParser;

    protected AbstractNacosDataParser(String extension) {
        if (StringUtils.isEmpty((Object)extension)) {
            throw new IllegalArgumentException("extension cannot be empty");
        }
        this.extension = extension.toLowerCase();
    }

    public final boolean checkFileExtension(String extension) {
        if (this.isLegal(extension.toLowerCase())) {
            return true;
        }
        if (this.nextParser == null) {
            return false;
        }
        return this.nextParser.checkFileExtension(extension);
    }

    public final Map<String, Object> parseNacosData(String data, String extension) throws IOException {
        if (extension == null || extension.length() < 1) {
            throw new IllegalStateException("The file extension cannot be empty");
        }
        if (this.isLegal(extension.toLowerCase())) {
            return this.doParse(data);
        }
        if (this.nextParser == null) {
            throw new IllegalStateException(AbstractNacosDataParser.getTips(extension));
        }
        return this.nextParser.parseNacosData(data, extension);
    }

    protected abstract Map<String, Object> doParse(String var1) throws IOException;

    protected AbstractNacosDataParser setNextParser(AbstractNacosDataParser nextParser) {
        this.nextParser = nextParser;
        return this;
    }

    public AbstractNacosDataParser addNextParser(AbstractNacosDataParser nextParser) {
        if (this.nextParser == null) {
            this.nextParser = nextParser;
        } else {
            this.nextParser.addNextParser(nextParser);
        }
        return this;
    }

    protected boolean isLegal(String extension) {
        return this.extension.equalsIgnoreCase(extension) || this.extension.contains(extension);
    }

    protected void flattenedMap(Map<String, Object> result, Map<String, Object> dataMap, String parentKey) {
        Set<Map.Entry<String, Object>> entries = dataMap.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String fullKey;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = StringUtils.isEmpty((Object)parentKey) ? key : (fullKey = key.startsWith("[") ? parentKey.concat(key) : parentKey.concat(DOT).concat(key));
            if (value instanceof Map) {
                Map map = (Map)value;
                this.flattenedMap(result, map, fullKey);
                continue;
            }
            if (value instanceof Collection) {
                int count = 0;
                Collection collection = (Collection)value;
                for (Object object : collection) {
                    this.flattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), fullKey);
                }
                continue;
            }
            result.put(fullKey, value);
        }
    }

    protected Map<String, Object> reloadMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            int idx;
            String suffix;
            String key = entry.getKey();
            if (!key.contains(DOT) || !VALUE.equalsIgnoreCase(suffix = key.substring((idx = key.lastIndexOf(DOT)) + 1))) continue;
            result.put(key.substring(0, idx), entry.getValue());
        }
        return result;
    }

    public static String getTips(String fileName) {
        return String.format("[%s] must contains file extension with properties|yaml|yml|xml|json", fileName);
    }
}

