/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel;

import com.alibaba.cloud.sentinel.datasource.config.DataSourcePropertiesConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="spring.cloud.sentinel")
@Validated
public class SentinelProperties {
    private boolean eager = false;
    private boolean enabled = true;
    private String blockPage;
    private Map<String, DataSourcePropertiesConfiguration> datasource = new TreeMap<String, DataSourcePropertiesConfiguration>(String.CASE_INSENSITIVE_ORDER);
    private Transport transport = new Transport();
    private Metric metric = new Metric();
    private Servlet servlet = new Servlet();
    private Filter filter = new Filter();
    private Flow flow = new Flow();
    private Log log = new Log();
    private Boolean httpMethodSpecify = false;
    private Boolean webContextUnify = true;

    public Boolean getWebContextUnify() {
        return this.webContextUnify;
    }

    public void setWebContextUnify(Boolean webContextUnify) {
        this.webContextUnify = webContextUnify;
    }

    public boolean isEager() {
        return this.eager;
    }

    public void setEager(boolean eager) {
        this.eager = eager;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Map<String, DataSourcePropertiesConfiguration> getDatasource() {
        return this.datasource;
    }

    public void setDatasource(Map<String, DataSourcePropertiesConfiguration> datasource) {
        this.datasource = datasource;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Boolean getHttpMethodSpecify() {
        return this.httpMethodSpecify;
    }

    public void setHttpMethodSpecify(Boolean httpMethodSpecify) {
        this.httpMethodSpecify = httpMethodSpecify;
    }

    public String getBlockPage() {
        if (StringUtils.hasText((String)this.blockPage)) {
            return this.blockPage;
        }
        return this.servlet.getBlockPage();
    }

    public void setBlockPage(String blockPage) {
        this.blockPage = blockPage;
    }

    public static class Transport {
        private String port = "8719";
        private String dashboard = "";
        private String heartbeatIntervalMs;
        private String clientIp;

        public String getHeartbeatIntervalMs() {
            return this.heartbeatIntervalMs;
        }

        public void setHeartbeatIntervalMs(String heartbeatIntervalMs) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getDashboard() {
            return this.dashboard;
        }

        public void setDashboard(String dashboard) {
            this.dashboard = dashboard;
        }

        public String getClientIp() {
            return this.clientIp;
        }

        public void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }
    }

    public static class Metric {
        private String fileSingleSize;
        private String fileTotalCount;
        private String charset = "UTF-8";

        public String getFileSingleSize() {
            return this.fileSingleSize;
        }

        public void setFileSingleSize(String fileSingleSize) {
            this.fileSingleSize = fileSingleSize;
        }

        public String getFileTotalCount() {
            return this.fileTotalCount;
        }

        public void setFileTotalCount(String fileTotalCount) {
            this.fileTotalCount = fileTotalCount;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }
    }

    public static class Servlet {
        private String blockPage;

        @Deprecated
        @DeprecatedConfigurationProperty(reason="replaced to SentinelProperties#blockPage.", replacement="spring.cloud.sentinel.block-page")
        public String getBlockPage() {
            return this.blockPage;
        }

        @Deprecated
        public void setBlockPage(String blockPage) {
            this.blockPage = blockPage;
        }
    }

    public static class Filter {
        private int order = Integer.MIN_VALUE;
        private List<String> urlPatterns = Arrays.asList("/**");
        private boolean enabled = true;

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public List<String> getUrlPatterns() {
            return this.urlPatterns;
        }

        public void setUrlPatterns(List<String> urlPatterns) {
            this.urlPatterns = urlPatterns;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Flow {
        private String coldFactor = "3";

        public String getColdFactor() {
            return this.coldFactor;
        }

        public void setColdFactor(String coldFactor) {
            this.coldFactor = coldFactor;
        }
    }

    public static class Log {
        private String dir;
        private boolean switchPid = false;

        public String getDir() {
            return this.dir;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public boolean isSwitchPid() {
            return this.switchPid;
        }

        public void setSwitchPid(boolean switchPid) {
            this.switchPid = switchPid;
        }
    }
}

