/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsValuesTableSource;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class OdpsSelectParser
extends SQLSelectParser {
    public OdpsSelectParser(SQLExprParser exprParser) {
        super(exprParser.getLexer());
        this.exprParser = exprParser;
    }

    public OdpsSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser.getLexer());
        this.exprParser = exprParser;
        this.selectListCache = selectListCache;
    }

    @Override
    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select, acceptUnion);
        }
        OdpsSelectQueryBlock queryBlock = new OdpsSelectQueryBlock();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            queryBlock.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.SELECT);
        if (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(queryBlock.getHints());
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.UNIQUE) {
            queryBlock.setDistionOption(3);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            queryBlock.setDistionOption(1);
            this.lexer.nextToken();
        }
        this.parseSelectList(queryBlock);
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        queryBlock.setOrderBy(this.exprParser.parseOrderBy());
        if (this.lexer.token() == Token.DISTRIBUTE) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem distributeByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addDistributeBy(distributeByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem sortByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addSortBy(sortByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTER)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            while (true) {
                SQLSelectOrderByItem clusterByItem = this.exprParser.parseSelectOrderByItem();
                queryBlock.addClusterBy(clusterByItem);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.LIMIT) {
            this.lexer.nextToken();
            queryBlock.setLimit(new SQLLimit(this.expr()));
        }
        return this.queryRest(queryBlock, acceptUnion);
    }

    @Override
    public SQLTableSource parseTableSource() {
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            OdpsValuesTableSource tableSource = new OdpsValuesTableSource();
            while (true) {
                this.accept(Token.LPAREN);
                SQLListExpr listExpr = new SQLListExpr();
                this.exprParser.exprList(listExpr.getItems(), listExpr);
                this.accept(Token.RPAREN);
                listExpr.setParent(tableSource);
                tableSource.getValues().add(listExpr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            String alias = this.tableAlias();
            tableSource.setAlias(alias);
            this.accept(Token.LPAREN);
            this.exprParser.names(tableSource.getColumns(), tableSource);
            this.accept(Token.RPAREN);
            return tableSource;
        }
        return super.parseTableSource();
    }
}

