/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleLobStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSupplementalIdKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSupplementalLogGrp;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.Token;

public class OracleCreateTableParser
extends SQLCreateTableParser {
    public OracleCreateTableParser(Lexer lexer) {
        super(new OracleExprParser(lexer));
    }

    public OracleCreateTableParser(String sql) {
        super(new OracleExprParser(sql));
    }

    @Override
    protected OracleCreateTableStatement newCreateStatement() {
        return new OracleCreateTableStatement();
    }

    @Override
    public OracleCreateTableStatement parseCreateTable(boolean acceptCreate) {
        OracleCreateTableStatement stmt;
        block30: {
            stmt = (OracleCreateTableStatement)super.parseCreateTable(acceptCreate);
            if (this.lexer.token() == Token.OF) {
                this.lexer.nextToken();
                stmt.setOf(this.exprParser.name());
                if (this.lexer.identifierEquals("OIDINDEX")) {
                    this.lexer.nextToken();
                    OracleCreateTableStatement.OIDIndex oidIndex = new OracleCreateTableStatement.OIDIndex();
                    if (this.lexer.token() != Token.LPAREN) {
                        oidIndex.setName(this.exprParser.name());
                    }
                    this.accept(Token.LPAREN);
                    this.getExprParser().parseSegmentAttributes(oidIndex);
                    this.accept(Token.RPAREN);
                    stmt.setOidIndex(oidIndex);
                }
            }
            while (true) {
                this.getExprParser().parseSegmentAttributes(stmt);
                if (this.lexer.identifierEquals("IN_MEMORY_METADATA")) {
                    this.lexer.nextToken();
                    stmt.setInMemoryMetadata(true);
                    continue;
                }
                if (this.lexer.identifierEquals("CURSOR_SPECIFIC_SEGMENT")) {
                    this.lexer.nextToken();
                    stmt.setCursorSpecificSegment(true);
                    continue;
                }
                if (this.lexer.identifierEquals("NOPARALLEL")) {
                    this.lexer.nextToken();
                    stmt.setParallel(false);
                    continue;
                }
                if (this.lexer.identifierEquals("PARALLEL")) {
                    this.lexer.nextToken();
                    stmt.setParallel(true);
                    continue;
                }
                if (this.lexer.token() == Token.CACHE) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.TRUE);
                    continue;
                }
                if (this.lexer.token() == Token.NOCACHE) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.FALSE);
                    continue;
                }
                if (this.lexer.token() == Token.ENABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.ROW) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("MOVEMENT");
                        stmt.setEnableRowMovement(Boolean.TRUE);
                        continue;
                    }
                    throw new ParserException("TODO : " + this.lexer.info());
                }
                if (this.lexer.token() == Token.DISABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.ROW) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("MOVEMENT");
                        stmt.setEnableRowMovement(Boolean.FALSE);
                        continue;
                    }
                    throw new ParserException("TODO : " + this.lexer.info());
                }
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    this.accept(Token.COMMIT);
                    if (this.lexer.identifierEquals("PRESERVE")) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("ROWS");
                        stmt.setOnCommitPreserveRows(true);
                        continue;
                    }
                    this.accept(Token.DELETE);
                    this.acceptIdentifier("ROWS");
                    stmt.setOnCommitDeleteRows(true);
                    continue;
                }
                if (this.lexer.identifierEquals("STORAGE")) {
                    OracleStorageClause storage = ((OracleExprParser)this.exprParser).parseStorage();
                    stmt.setStorage(storage);
                    continue;
                }
                if (this.lexer.identifierEquals("ORGANIZATION")) {
                    this.parseOrganization(stmt);
                    continue;
                }
                if (this.lexer.identifierEquals("CLUSTER")) {
                    this.lexer.nextToken();
                    SQLName cluster = this.exprParser.name();
                    stmt.setCluster(cluster);
                    this.accept(Token.LPAREN);
                    this.exprParser.names(stmt.getClusterColumns(), cluster);
                    this.accept(Token.RPAREN);
                    continue;
                }
                if (this.lexer.identifierEquals("MONITORING")) {
                    this.lexer.nextToken();
                    stmt.setMonitoring(true);
                    continue;
                }
                if (this.lexer.token() == Token.LOB) {
                    OracleLobStorageClause lobStorage = ((OracleExprParser)this.exprParser).parseLobStorage();
                    stmt.setLobStorage(lobStorage);
                    continue;
                }
                if (this.lexer.token() == Token.SEGMENT) {
                    this.lexer.nextToken();
                    this.accept(Token.CREATION);
                    if (this.lexer.token() == Token.IMMEDIATE) {
                        this.lexer.nextToken();
                        stmt.setDeferredSegmentCreation(OracleCreateTableStatement.DeferredSegmentCreation.IMMEDIATE);
                        continue;
                    }
                    this.accept(Token.DEFERRED);
                    stmt.setDeferredSegmentCreation(OracleCreateTableStatement.DeferredSegmentCreation.DEFERRED);
                    continue;
                }
                if (this.lexer.token() != Token.PARTITION) break block30;
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.lexer.identifierEquals("RANGE")) {
                    SQLPartitionByRange partitionByRange = this.getExprParser().partitionByRange();
                    this.getExprParser().partitionClauseRest(partitionByRange);
                    stmt.setPartitioning(partitionByRange);
                    continue;
                }
                if (this.lexer.identifierEquals("HASH")) {
                    SQLPartitionByHash partitionByHash = this.getExprParser().partitionByHash();
                    this.getExprParser().partitionClauseRest(partitionByHash);
                    if (this.lexer.token() == Token.LPAREN) {
                        this.lexer.nextToken();
                        while (true) {
                            SQLPartition partition = this.getExprParser().parsePartition();
                            partitionByHash.addPartition(partition);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        if (this.lexer.token() == Token.RPAREN) {
                            this.lexer.nextToken();
                        } else {
                            throw new ParserException("TODO : " + this.lexer.info());
                        }
                    }
                    stmt.setPartitioning(partitionByHash);
                    continue;
                }
                if (!this.lexer.identifierEquals("LIST")) break;
                SQLPartitionByList partitionByList = this.partitionByList();
                this.getExprParser().partitionClauseRest(partitionByList);
                stmt.setPartitioning(partitionByList);
            }
            throw new ParserException("TODO : " + this.lexer.info());
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            SQLSelect select = new OracleSelectParser(this.exprParser).select();
            stmt.setSelect(select);
        }
        return stmt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseOrganization(OracleCreateTableStatement stmt) {
        OracleCreateTableStatement.Organization organization = new OracleCreateTableStatement.Organization();
        this.acceptIdentifier("ORGANIZATION");
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
            organization.setType("INDEX");
            this.getExprParser().parseSegmentAttributes(organization);
            if (this.lexer.identifierEquals("PCTTHRESHOLD")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LITERAL_INT) {
                    int pctthreshold = ((SQLNumericLiteralExpr)this.exprParser.primary()).getNumber().intValue();
                    organization.setPctthreshold(pctthreshold);
                }
            }
        } else if (this.lexer.identifierEquals("HEAP")) {
            this.lexer.nextToken();
            organization.setType("HEAP");
            this.getExprParser().parseSegmentAttributes(organization);
        } else {
            if (!this.lexer.identifierEquals("EXTERNAL")) throw new ParserException("TODO " + this.lexer.info());
            this.lexer.nextToken();
            organization.setType("EXTERNAL");
            this.accept(Token.LPAREN);
            if (this.lexer.identifierEquals("TYPE")) {
                this.lexer.nextToken();
                organization.setExternalType(this.exprParser.name());
            }
            this.accept(Token.DEFAULT);
            this.acceptIdentifier("DIRECTORY");
            organization.setExternalDirectory(this.exprParser.expr());
            if (this.lexer.identifierEquals("ACCESS")) {
                this.lexer.nextToken();
                this.acceptIdentifier("PARAMETERS");
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    OracleCreateTableStatement.OracleExternalRecordFormat recordFormat = new OracleCreateTableStatement.OracleExternalRecordFormat();
                    if (this.lexer.identifierEquals("RECORDS")) {
                        this.lexer.nextToken();
                        if (!this.lexer.identifierEquals("DELIMITED")) throw new ParserException("TODO " + this.lexer.info());
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                        if (!this.lexer.identifierEquals("NEWLINE")) throw new ParserException("TODO " + this.lexer.info());
                        this.lexer.nextToken();
                        recordFormat.setDelimitedBy(new SQLIdentifierExpr("NEWLINE"));
                    }
                    if (this.lexer.identifierEquals("FIELDS")) {
                        this.lexer.nextToken();
                        if (!this.lexer.identifierEquals("TERMINATED")) throw new ParserException("TODO " + this.lexer.info());
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                        recordFormat.setTerminatedBy(this.exprParser.primary());
                    }
                    organization.setExternalDirectoryRecordFormat(recordFormat);
                    this.accept(Token.RPAREN);
                } else if (this.lexer.token() == Token.USING) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("CLOB");
                    throw new ParserException("TODO " + this.lexer.info());
                }
            }
            this.acceptIdentifier("LOCATION");
            this.accept(Token.LPAREN);
            this.exprParser.exprList(organization.getExternalDirectoryLocation(), organization);
            this.accept(Token.RPAREN);
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.REJECT) {
                this.lexer.nextToken();
                this.accept(Token.LIMIT);
                organization.setExternalRejectLimit(this.exprParser.primary());
            }
        }
        stmt.setOrganization(organization);
    }

    protected SQLPartitionByList partitionByList() {
        this.acceptIdentifier("LIST");
        SQLPartitionByList partitionByList = new SQLPartitionByList();
        this.accept(Token.LPAREN);
        partitionByList.setExpr(this.exprParser.expr());
        this.accept(Token.RPAREN);
        this.getExprParser().parsePartitionByRest(partitionByList);
        return partitionByList;
    }

    @Override
    protected void parseCreateTableSupplementalLogingProps(SQLCreateTableStatement stmt) {
        this.acceptIdentifier("SUPPLEMENTAL");
        this.acceptIdentifier("LOG");
        if (this.lexer.token() == Token.GROUP) {
            this.lexer.nextToken();
            OracleSupplementalLogGrp logGrp = new OracleSupplementalLogGrp();
            logGrp.setGroup(this.exprParser.name());
            this.accept(Token.LPAREN);
            while (true) {
                SQLName column = this.exprParser.name();
                if (this.lexer.identifierEquals("NO")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("LOG");
                    column.putAttribute("NO LOG", Boolean.TRUE);
                }
                logGrp.addColumn(column);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() != Token.RPAREN) {
                throw new ParserException("TODO " + this.lexer.info());
            }
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals("ALWAYS")) {
                this.lexer.nextToken();
                logGrp.setAlways(true);
            }
            logGrp.setParent(stmt);
            stmt.getTableElementList().add(logGrp);
        } else {
            this.acceptIdentifier("DATA");
            OracleSupplementalIdKey idKey = new OracleSupplementalIdKey();
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() == Token.ALL) {
                    this.lexer.nextToken();
                    idKey.setAll(true);
                } else if (this.lexer.token() == Token.PRIMARY) {
                    this.lexer.nextToken();
                    this.accept(Token.KEY);
                    idKey.setPrimaryKey(true);
                } else if (this.lexer.token() == Token.UNIQUE) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.INDEX) {
                        this.lexer.nextToken();
                        idKey.setUniqueIndex(true);
                    } else {
                        idKey.setUnique(true);
                    }
                } else if (this.lexer.token() == Token.FOREIGN) {
                    this.lexer.nextToken();
                    this.accept(Token.KEY);
                    idKey.setForeignKey(true);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() != Token.RPAREN) {
                throw new ParserException("TODO " + this.lexer.info());
            }
            this.accept(Token.RPAREN);
            this.acceptIdentifier("COLUMNS");
            idKey.setParent(stmt);
            stmt.getTableElementList().add(idKey);
        }
    }

    @Override
    public OracleExprParser getExprParser() {
        return (OracleExprParser)this.exprParser;
    }
}

