/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2OutputVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.phoenix.visitor.PhoenixOutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.ParameterizedVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class ParameterizedOutputVisitorUtils {
    private static final SQLParserFeature[] features = new SQLParserFeature[]{SQLParserFeature.EnableSQLBinaryOpExprGroup, SQLParserFeature.OptimizedForParameterized};

    public static String parameterize(String sql, String dbType) {
        return ParameterizedOutputVisitorUtils.parameterize(sql, dbType, null);
    }

    public static String parameterize(String sql, String dbType, SQLSelectListCache selectListCache) {
        List<SQLStatement> statementList;
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType, features);
        if (selectListCache != null) {
            parser.setSelectListCache(selectListCache);
        }
        if ((statementList = parser.parseStatementList()).size() == 0) {
            return sql;
        }
        StringBuilder out = new StringBuilder(sql.length());
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, dbType);
        for (int i = 0; i < statementList.size(); ++i) {
            SQLStatement stmt;
            if (i > 0) {
                out.append(";\n");
            }
            if ((stmt = statementList.get(i)).hasBeforeComment()) {
                stmt.getBeforeCommentsDirect().clear();
            }
            stmt.accept(visitor);
        }
        if (visitor.getReplaceCount() == 0 && parser.getLexer().getCommentCount() == 0 && sql.charAt(0) != '/') {
            return sql;
        }
        return out.toString();
    }

    public static String parameterize(List<SQLStatement> statementList, String dbType) {
        StringBuilder out = new StringBuilder();
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, dbType);
        for (int i = 0; i < statementList.size(); ++i) {
            SQLStatement stmt;
            if (i > 0) {
                out.append(";\n");
            }
            if ((stmt = statementList.get(i)).hasBeforeComment()) {
                stmt.getBeforeCommentsDirect().clear();
            }
            stmt.accept(visitor);
        }
        return out.toString();
    }

    public static ParameterizedVisitor createParameterizedOutputVisitor(Appendable out, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleParameterizedOutputVisitor(out);
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlOutputVisitor(out, true);
        }
        if ("postgresql".equals(dbType) || "edb".equals(dbType)) {
            return new PGOutputVisitor(out, true);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerOutputVisitor(out, true);
        }
        if ("db2".equals(dbType)) {
            return new DB2OutputVisitor(out, true);
        }
        if ("phoenix".equals(dbType)) {
            return new PhoenixOutputVisitor(out, true);
        }
        if ("elastic_search".equals(dbType)) {
            return new MySqlOutputVisitor(out, true);
        }
        return new SQLASTOutputVisitor(out, true);
    }
}

