/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExtractExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlMatchAgainstExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlUserName;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class MySqlExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public MySqlExprParser(Lexer lexer) {
        super(lexer, "mysql");
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    public MySqlExprParser(String sql) {
        this(new MySqlLexer(sql));
        this.lexer.nextToken();
    }

    public MySqlExprParser(String sql, SQLParserFeature ... features) {
        super(new MySqlLexer(sql, features), "mysql");
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
        if (sql.length() > 6) {
            char c0 = sql.charAt(0);
            char c1 = sql.charAt(1);
            char c2 = sql.charAt(2);
            char c3 = sql.charAt(3);
            char c4 = sql.charAt(4);
            char c5 = sql.charAt(5);
            char c6 = sql.charAt(6);
            if (c0 == 'S' && c1 == 'E' && c2 == 'L' && c3 == 'E' && c4 == 'C' && c5 == 'T' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.SELECT);
                return;
            }
            if (c0 == 's' && c1 == 'e' && c2 == 'l' && c3 == 'e' && c4 == 'c' && c5 == 't' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.SELECT);
                return;
            }
            if (c0 == 'I' && c1 == 'N' && c2 == 'S' && c3 == 'E' && c4 == 'R' && c5 == 'T' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.INSERT);
                return;
            }
            if (c0 == 'i' && c1 == 'n' && c2 == 's' && c3 == 'e' && c4 == 'r' && c5 == 't' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.INSERT);
                return;
            }
            if (c0 == 'U' && c1 == 'P' && c2 == 'D' && c3 == 'A' && c4 == 'T' && c5 == 'E' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.UPDATE);
                return;
            }
            if (c0 == 'u' && c1 == 'p' && c2 == 'd' && c3 == 'a' && c4 == 't' && c5 == 'e' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.UPDATE);
                return;
            }
            if (c0 == '/' && c1 == '*' && this.isEnabled(SQLParserFeature.OptimizedForParameterized)) {
                MySqlLexer mySqlLexer = (MySqlLexer)this.lexer;
                mySqlLexer.skipFirstHintsOrMultiCommentAndNextToken();
                return;
            }
        }
        this.lexer.nextToken();
    }

    public MySqlExprParser(String sql, boolean keepComments) {
        this(new MySqlLexer(sql, true, keepComments));
        this.lexer.nextToken();
    }

    public MySqlExprParser(String sql, boolean skipComment, boolean keepComments) {
        this(new MySqlLexer(sql, skipComment, keepComments));
        this.lexer.nextToken();
    }

    @Override
    public SQLExpr primary() {
        Token tok = this.lexer.token();
        if (this.lexer.identifierEquals(FnvHash.Constants.OUTFILE)) {
            this.lexer.nextToken();
            SQLExpr file = this.primary();
            MySqlOutFileExpr expr = new MySqlOutFileExpr(file);
            return this.primaryRest(expr);
        }
        switch (tok) {
            case VARIANT: {
                SQLVariantRefExpr varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                if (varRefExpr.getName().equalsIgnoreCase("@@global")) {
                    this.accept(Token.DOT);
                    varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal(), true);
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                }
                return this.primaryRest(varRefExpr);
            }
            case VALUES: {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LPAREN) {
                    throw new ParserException("syntax error, illegal values clause. " + this.lexer.info());
                }
                return this.methodRest(new SQLIdentifierExpr("VALUES"), true);
            }
            case BINARY: {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COMMA || this.lexer.token() == Token.SEMI || this.lexer.token() == Token.EOF) {
                    return new SQLIdentifierExpr("BINARY");
                }
                SQLUnaryExpr binaryExpr = new SQLUnaryExpr(SQLUnaryOperator.BINARY, this.expr());
                return this.primaryRest(binaryExpr);
            }
        }
        return super.primary();
    }

    @Override
    public final SQLExpr primaryRest(SQLExpr expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                String ident = identExpr.getName();
                if (ident.equalsIgnoreCase("x")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr = new SQLHexExpr(charValue);
                    return this.primaryRest(expr);
                }
                if (ident.startsWith("_")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    MySqlCharExpr mysqlCharExpr = new MySqlCharExpr(charValue);
                    mysqlCharExpr.setCharset(identExpr.getName());
                    if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                        this.lexer.nextToken();
                        String collate = this.lexer.stringVal();
                        mysqlCharExpr.setCollate(collate);
                        this.accept(Token.IDENTIFIER);
                    }
                    expr = mysqlCharExpr;
                    return this.primaryRest(expr);
                }
            } else if (expr instanceof SQLCharExpr) {
                SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("CONCAT");
                concat.addParameter(expr);
                do {
                    String chars = this.lexer.stringVal();
                    concat.addParameter(new SQLCharExpr(chars));
                    this.lexer.nextToken();
                } while (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS);
                expr = concat;
            }
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            if (expr instanceof SQLHexExpr) {
                if ("USING".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("syntax error, illegal hex. " + this.lexer.info());
                    }
                    String charSet = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr.getAttributes().put("USING", charSet);
                    return this.primaryRest(expr);
                }
            } else {
                if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.EQ) {
                        this.lexer.nextToken();
                    }
                    if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.LITERAL_CHARS) {
                        throw new ParserException("syntax error. " + this.lexer.info());
                    }
                    String collate = this.lexer.stringVal();
                    this.lexer.nextToken();
                    SQLBinaryOpExpr binaryExpr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.COLLATE, new SQLIdentifierExpr(collate), "mysql");
                    expr = binaryExpr;
                    return this.primaryRest(expr);
                }
                if (expr instanceof SQLVariantRefExpr && this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.LITERAL_CHARS) {
                        throw new ParserException("syntax error. " + this.lexer.info());
                    }
                    String collate = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr.putAttribute("COLLATE", collate);
                    return this.primaryRest(expr);
                }
            }
        }
        if (this.lexer.token() == Token.VARIANT && "@".equals(this.lexer.stringVal())) {
            return this.userNameRest(expr);
        }
        if (this.lexer.token() == Token.ERROR) {
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        return super.primaryRest(expr);
    }

    public SQLName userName() {
        SQLName name = this.name();
        if (this.lexer.token() == Token.LPAREN && name.hashCode64() == FnvHash.Constants.CURRENT_USER) {
            this.lexer.nextToken();
            this.accept(Token.RPAREN);
            return name;
        }
        return (SQLName)this.userNameRest(name);
    }

    private SQLExpr userNameRest(SQLExpr expr) {
        if (this.lexer.token() != Token.VARIANT || !this.lexer.stringVal().startsWith("@")) {
            return expr;
        }
        MySqlUserName userName = new MySqlUserName();
        if (expr instanceof SQLCharExpr) {
            userName.setUserName(((SQLCharExpr)expr).toString());
        } else {
            userName.setUserName(((SQLIdentifierExpr)expr).getName());
        }
        String strVal = this.lexer.stringVal();
        this.lexer.nextToken();
        if (strVal.length() > 1) {
            userName.setHost(strVal.substring(1));
            return userName;
        }
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            userName.setHost("'" + this.lexer.stringVal() + "'");
        } else {
            userName.setHost(this.lexer.stringVal());
        }
        this.lexer.nextToken();
        return userName;
    }

    @Override
    protected SQLExpr parsePosition() {
        SQLExpr subStr = this.primary();
        this.accept(Token.IN);
        SQLExpr str = this.expr();
        this.accept(Token.RPAREN);
        SQLMethodInvokeExpr locate = new SQLMethodInvokeExpr("LOCATE");
        locate.addParameter(subStr);
        locate.addParameter(str);
        return this.primaryRest(locate);
    }

    @Override
    protected SQLExpr parseExtract() {
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        String unitVal = this.lexer.stringVal();
        SQLIntervalUnit unit = SQLIntervalUnit.valueOf(unitVal.toUpperCase());
        this.lexer.nextToken();
        this.accept(Token.FROM);
        SQLExpr value = this.expr();
        MySqlExtractExpr extract = new MySqlExtractExpr();
        extract.setValue(value);
        extract.setUnit(unit);
        this.accept(Token.RPAREN);
        MySqlExtractExpr expr = extract;
        return this.primaryRest(expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SQLExpr parseMatch() {
        MySqlMatchAgainstExpr matchAgainstExpr = new MySqlMatchAgainstExpr();
        if (this.lexer.token() == Token.RPAREN) {
            this.lexer.nextToken();
        } else {
            this.exprList(matchAgainstExpr.getColumns(), matchAgainstExpr);
            this.accept(Token.RPAREN);
        }
        this.acceptIdentifier("AGAINST");
        this.accept(Token.LPAREN);
        SQLExpr against = this.primary();
        matchAgainstExpr.setAgainst(against);
        if (this.lexer.token() == Token.IN) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.NATURAL)) {
                this.lexer.nextToken();
                this.acceptIdentifier("LANGUAGE");
                this.acceptIdentifier("MODE");
                if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("QUERY");
                    this.acceptIdentifier("EXPANSION");
                    matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_NATURAL_LANGUAGE_MODE_WITH_QUERY_EXPANSION);
                } else {
                    matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_NATURAL_LANGUAGE_MODE);
                }
            } else {
                if (!this.lexer.identifierEquals(FnvHash.Constants.BOOLEAN)) throw new ParserException("syntax error. " + this.lexer.info());
                this.lexer.nextToken();
                this.acceptIdentifier("MODE");
                matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_BOOLEAN_MODE);
            }
        } else if (this.lexer.token() == Token.WITH) {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        this.accept(Token.RPAREN);
        return this.primaryRest(matchAgainstExpr);
    }

    @Override
    public SQLSelectParser createSelectParser() {
        return new MySqlSelectParser(this);
    }

    @Override
    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("INTERVAL");
            if (this.lexer.token() != Token.RPAREN) {
                this.exprList(methodInvokeExpr.getParameters(), methodInvokeExpr);
            }
            this.accept(Token.RPAREN);
            if (methodInvokeExpr.getParameters().size() == 1 && this.lexer.token() == Token.IDENTIFIER) {
                SQLExpr value = methodInvokeExpr.getParameters().get(0);
                String unit = this.lexer.stringVal();
                this.lexer.nextToken();
                SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
                intervalExpr.setValue(value);
                intervalExpr.setUnit(SQLIntervalUnit.valueOf(unit.toUpperCase()));
                return intervalExpr;
            }
            return this.primaryRest(methodInvokeExpr);
        }
        SQLExpr value = this.expr();
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("Syntax error. " + this.lexer.info());
        }
        String unit = this.lexer.stringVal();
        this.lexer.nextToken();
        SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
        intervalExpr.setValue(value);
        intervalExpr.setUnit(SQLIntervalUnit.valueOf(unit.toUpperCase()));
        return intervalExpr;
    }

    @Override
    public SQLColumnDefinition parseColumn() {
        SQLColumnDefinition column = new SQLColumnDefinition();
        column.setDbType(this.dbType);
        column.setName(this.name());
        column.setDataType(this.parseDataType());
        return this.parseColumnRest(column);
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        SQLExpr expr;
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            expr = this.expr();
            column.setOnUpdate(expr);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CHARSET)) {
            this.lexer.nextToken();
            MySqlCharExpr charSetCollateExpr = new MySqlCharExpr();
            charSetCollateExpr.setCharset(this.lexer.stringVal());
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                this.lexer.nextToken();
                charSetCollateExpr.setCollate(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            column.setCharsetExpr(charSetCollateExpr);
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.AUTO_INCREMENT)) {
            this.lexer.nextToken();
            column.setAutoIncrement(true);
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PRECISION) && column.getDataType().nameHashCode64() == FnvHash.Constants.DOUBLE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.PARTITION) {
            throw new ParserException("syntax error " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORAGE)) {
            this.lexer.nextToken();
            expr = this.expr();
            column.setStorage(expr);
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            expr = this.expr();
            column.setAsExpr(expr);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            column.setSorted(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.VIRTUAL)) {
            this.lexer.nextToken();
            column.setVirtual(true);
        }
        super.parseColumnRest(column);
        return column;
    }

    @Override
    protected SQLDataType parseDataTypeRest(SQLDataType dataType) {
        super.parseDataTypeRest(dataType);
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.UNSIGNED)) {
                this.lexer.nextToken();
                ((SQLDataTypeImpl)dataType).setUnsigned(true);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.ZEROFILL)) break;
            this.lexer.nextToken();
            ((SQLDataTypeImpl)dataType).setZerofill(true);
        }
        return dataType;
    }

    @Override
    public SQLAssignItem parseAssignItem() {
        SQLAssignItem item = new SQLAssignItem();
        SQLExpr var = this.primary();
        String ident = null;
        long identHash = 0L;
        if (var instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)var;
            ident = identExpr.getName();
            identHash = identExpr.hashCode64();
            if (identHash == FnvHash.Constants.GLOBAL) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, true);
            } else if (identHash == FnvHash.Constants.SESSION) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, false, true);
            } else {
                var = new SQLVariantRefExpr(ident);
            }
        }
        if (identHash == FnvHash.Constants.NAMES) {
            String charset = this.lexer.stringVal();
            SQLVariantRefExpr varExpr = null;
            boolean chars = false;
            Token token = this.lexer.token();
            if (token == Token.IDENTIFIER) {
                this.lexer.nextToken();
            } else if (token == Token.DEFAULT) {
                charset = "DEFAULT";
                this.lexer.nextToken();
            } else if (token == Token.QUES) {
                varExpr = new SQLVariantRefExpr("?");
                this.lexer.nextToken();
            } else {
                chars = true;
                this.accept(Token.LITERAL_CHARS);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                MySqlCharExpr charsetExpr = new MySqlCharExpr(charset);
                this.lexer.nextToken();
                String collate = this.lexer.stringVal();
                this.lexer.nextToken();
                charsetExpr.setCollate(collate);
                item.setValue(charsetExpr);
            } else if (varExpr != null) {
                item.setValue(varExpr);
            } else {
                item.setValue(chars ? new SQLCharExpr(charset) : new SQLIdentifierExpr(charset));
            }
            item.setTarget(var);
            return item;
        }
        if (identHash == FnvHash.Constants.CHARACTER) {
            var = new SQLIdentifierExpr("CHARACTER SET");
            this.accept(Token.SET);
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
        } else if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.EQ);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            item.setValue(new SQLIdentifierExpr("ON"));
        } else {
            item.setValue(this.expr());
        }
        item.setTarget(var);
        return item;
    }

    @Override
    public SQLName nameRest(SQLName name) {
        if (this.lexer.token() == Token.VARIANT && "@".equals(this.lexer.stringVal())) {
            this.lexer.nextToken();
            MySqlUserName userName = new MySqlUserName();
            userName.setUserName(((SQLIdentifierExpr)name).getName());
            if (this.lexer.token() == Token.LITERAL_CHARS) {
                userName.setHost("'" + this.lexer.stringVal() + "'");
            } else {
                userName.setHost(this.lexer.stringVal());
            }
            this.lexer.nextToken();
            return userName;
        }
        return super.nameRest(name);
    }

    @Override
    public MySqlPrimaryKey parsePrimaryKey() {
        this.accept(Token.PRIMARY);
        this.accept(Token.KEY);
        MySqlPrimaryKey primaryKey = new MySqlPrimaryKey();
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            primaryKey.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() != Token.LPAREN) {
            SQLName name = this.name();
            primaryKey.setName(name);
        }
        this.accept(Token.LPAREN);
        while (true) {
            primaryKey.addColumn(this.expr());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            primaryKey.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        return primaryKey;
    }

    @Override
    public MySqlUnique parseUnique() {
        this.accept(Token.UNIQUE);
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
        }
        MySqlUnique unique = new MySqlUnique();
        if (this.lexer.token() != Token.LPAREN) {
            SQLName indexName = this.name();
            unique.setName(indexName);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            unique.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        this.accept(Token.LPAREN);
        while (true) {
            SQLExpr column = this.expr();
            if (this.lexer.token() == Token.ASC) {
                column = new MySqlOrderingExpr(column, SQLOrderingSpecification.ASC);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DESC) {
                column = new MySqlOrderingExpr(column, SQLOrderingSpecification.DESC);
                this.lexer.nextToken();
            }
            unique.addColumn(column);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            unique.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        return unique;
    }

    @Override
    public MysqlForeignKey parseForeignKey() {
        this.accept(Token.FOREIGN);
        this.accept(Token.KEY);
        MysqlForeignKey fk = new MysqlForeignKey();
        if (this.lexer.token() != Token.LPAREN) {
            SQLName indexName = this.name();
            fk.setIndexName(indexName);
        }
        this.accept(Token.LPAREN);
        this.names(fk.getReferencingColumns(), fk);
        this.accept(Token.RPAREN);
        this.accept(Token.REFERENCES);
        fk.setReferencedTableName(this.name());
        this.accept(Token.LPAREN);
        this.names(fk.getReferencedColumns());
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals(FnvHash.Constants.MATCH)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("FULL") || this.lexer.token() == Token.FULL) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.FULL);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PARTIAL)) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.PARTIAL);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.SIMPLE)) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.SIMPLE);
                this.lexer.nextToken();
            } else {
                throw new ParserException("TODO : " + this.lexer.info());
            }
        }
        while (this.lexer.token() == Token.ON) {
            SQLForeignKeyImpl.Option option;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DELETE) {
                this.lexer.nextToken();
                option = this.parseReferenceOption();
                fk.setOnDelete(option);
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                this.lexer.nextToken();
                option = this.parseReferenceOption();
                fk.setOnUpdate(option);
                continue;
            }
            throw new ParserException("syntax error, expect DELETE or UPDATE, actual " + (Object)((Object)this.lexer.token()) + " " + this.lexer.info());
        }
        return fk;
    }

    @Override
    protected SQLAggregateExpr parseAggregateExprRest(SQLAggregateExpr aggregateExpr) {
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.parseOrderBy();
            aggregateExpr.putAttribute("ORDER BY", orderBy);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SEPARATOR)) {
            this.lexer.nextToken();
            SQLExpr seperator = this.primary();
            seperator.setParent(aggregateExpr);
            aggregateExpr.putAttribute("SEPARATOR", seperator);
        }
        return aggregateExpr;
    }

    public MySqlOrderingExpr parseSelectGroupByItem() {
        MySqlOrderingExpr item = new MySqlOrderingExpr();
        item.setExpr(this.expr());
        if (this.lexer.token() == Token.ASC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.ASC);
        } else if (this.lexer.token() == Token.DESC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.DESC);
        }
        return item;
    }

    public SQLPartition parsePartition() {
        this.accept(Token.PARTITION);
        SQLPartition partitionDef = new SQLPartition();
        partitionDef.setName(this.name());
        SQLPartitionValue values = this.parsePartitionValues();
        if (values != null) {
            partitionDef.setValues(values);
        }
        while (true) {
            boolean storage = false;
            if (this.lexer.identifierEquals(FnvHash.Constants.DATA)) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                partitionDef.setDataDirectory(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.TABLESPACE) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLName tableSpace = this.name();
                partitionDef.setTablespace(tableSpace);
                continue;
            }
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                partitionDef.setIndexDirectory(this.expr());
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MAX_ROWS)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr maxRows = this.primary();
                partitionDef.setMaxRows(maxRows);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MIN_ROWS)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr minRows = this.primary();
                partitionDef.setMaxRows(minRows);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE) || (storage = this.lexer.token() == Token.STORAGE || this.lexer.identifierEquals(FnvHash.Constants.STORAGE))) {
                if (storage) {
                    this.lexer.nextToken();
                }
                this.acceptIdentifier("ENGINE");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLName engine = this.name();
                partitionDef.setEngine(engine);
                continue;
            }
            if (this.lexer.token() != Token.COMMENT) break;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr comment = this.primary();
            partitionDef.setComment(comment);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                this.acceptIdentifier("SUBPARTITION");
                SQLName subPartitionName = this.name();
                SQLSubPartition subPartition = new SQLSubPartition();
                subPartition.setName(subPartitionName);
                partitionDef.addSubPartition(subPartition);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return partitionDef;
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "GROUP_CONCAT", "MAX", "MIN", "STDDEV", "SUM"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            MySqlExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

