/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jakarta;

import com.alibaba.druid.filter.stat.StatFilterContextListenerAdapter;
import com.alibaba.druid.support.http.stat.WebAppStat;
import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.support.http.stat.WebSessionStat;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.DruidWebUtils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;

public class AbstractWebStatImpl {
    private static final Log LOG = LogFactory.getLog(AbstractWebStatImpl.class);
    public static final int DEFAULT_MAX_STAT_SESSION_COUNT = 1000;
    protected WebAppStat webAppStat;
    protected boolean sessionStatEnable = true;
    protected int sessionStatMaxCount = 1000;
    protected boolean createSession;
    protected boolean profileEnable;
    protected String contextPath;
    protected String principalSessionName;
    protected String principalCookieName;
    protected String realIpHeader;
    protected WebStatFilterContextListener statFilterContextListener = new WebStatFilterContextListener();

    public boolean isSessionStatEnable() {
        return this.sessionStatEnable;
    }

    public void setSessionStatEnable(boolean sessionStatEnable) {
        this.sessionStatEnable = sessionStatEnable;
    }

    public boolean isProfileEnable() {
        return this.profileEnable;
    }

    public void setProfileEnable(boolean profileEnable) {
        this.profileEnable = profileEnable;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getSessionStatMaxCount() {
        return this.sessionStatMaxCount;
    }

    public String getRequestURI(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public String getPrincipalSessionName() {
        return this.principalSessionName;
    }

    public String getPrincipalCookieName() {
        return this.principalCookieName;
    }

    public WebSessionStat getSessionStat(HttpServletRequest request) {
        if (!this.isSessionStatEnable()) {
            return null;
        }
        WebSessionStat sessionStat = null;
        String sessionId = this.getSessionId(request);
        if (sessionId != null) {
            sessionStat = this.webAppStat.getSessionStat(sessionId, true);
        }
        if (sessionStat != null) {
            long currentMillis = System.currentTimeMillis();
            String userAgent = request.getHeader("user-agent");
            if (sessionStat.getCreateTimeMillis() == -1L) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    sessionStat.setCreateTimeMillis(session.getCreationTime());
                } else {
                    sessionStat.setCreateTimeMillis(currentMillis);
                }
                this.webAppStat.computeUserAgent(userAgent);
                this.webAppStat.incrementSessionCount();
            }
            sessionStat.setUserAgent(userAgent);
            String ip = this.getRemoteAddress(request);
            sessionStat.addRemoteAddress(ip);
        }
        return sessionStat;
    }

    protected String getRemoteAddress(HttpServletRequest request) {
        String ip = null;
        if (this.realIpHeader != null && this.realIpHeader.length() != 0) {
            ip = request.getHeader(this.realIpHeader);
        }
        if (ip == null || ip.length() == 0) {
            ip = DruidWebUtils.getRemoteAddr(request);
        }
        return ip;
    }

    public String getSessionId(HttpServletRequest httpRequest) {
        String sessionId = null;
        HttpSession session = httpRequest.getSession(this.createSession);
        if (session != null) {
            sessionId = session.getId();
        } else {
            Cookie[] cookies = httpRequest.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals("JSESSIONID")) continue;
                    sessionId = cookie.getValue();
                    break;
                }
                if (sessionId == null) {
                    for (Cookie cookie : cookies) {
                        if (!cookie.getName().equals("JWT-SESSION")) continue;
                        sessionId = cookie.getValue();
                        break;
                    }
                }
            }
        }
        return sessionId;
    }

    public String getPrincipal(HttpServletRequest httpRequest) {
        if (this.principalSessionName != null) {
            Object sessionValue;
            block7: {
                HttpSession session = httpRequest.getSession(this.createSession);
                if (session == null) {
                    return null;
                }
                sessionValue = null;
                try {
                    sessionValue = session.getAttribute(this.principalSessionName);
                }
                catch (Exception ex) {
                    if (!LOG.isErrorEnabled()) break block7;
                    LOG.error("session.getAttribute error", ex);
                }
            }
            if (sessionValue == null) {
                return null;
            }
            return sessionValue.toString();
        }
        if (this.principalCookieName != null && httpRequest.getCookies() != null) {
            for (Cookie cookie : httpRequest.getCookies()) {
                if (!this.principalCookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static class WebStatFilterContextListener
    extends StatFilterContextListenerAdapter {
        @Override
        public void addUpdateCount(int updateCount) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.addJdbcUpdateCount(updateCount);
            }
        }

        @Override
        public void addFetchRowCount(int fetchRowCount) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.addJdbcFetchRowCount(fetchRowCount);
            }
        }

        @Override
        public void executeBefore(String sql, boolean inTransaction) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcExecuteCount();
            }
        }

        @Override
        public void executeAfter(String sql, long nanos, Throwable error) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.addJdbcExecuteTimeNano(nanos);
                if (error != null) {
                    reqStat.incrementJdbcExecuteErrorCount();
                }
            }
        }

        @Override
        public void commit() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcCommitCount();
            }
        }

        @Override
        public void rollback() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcRollbackCount();
            }
        }

        @Override
        public void pool_connect() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcPoolConnectCount();
            }
        }

        @Override
        public void pool_close(long nanos) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcPoolCloseCount();
            }
        }

        @Override
        public void resultSet_open() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcResultSetOpenCount();
            }
        }

        @Override
        public void resultSet_close(long nanos) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcResultSetCloseCount();
            }
        }
    }
}

