/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SQLDropTableStatement
extends SQLStatementImpl
implements SQLDropStatement {
    private List<SQLCommentHint> hints;
    protected List<SQLExprTableSource> tableSources = new ArrayList<SQLExprTableSource>();
    protected boolean purge;
    protected boolean cascade;
    protected boolean restrict;
    protected boolean ifExists;
    private boolean temporary;
    private boolean external;
    private boolean isDropPartition;
    private SQLExpr where;

    public SQLDropTableStatement() {
    }

    public SQLDropTableStatement(DbType dbType) {
        super(dbType);
    }

    public SQLDropTableStatement(SQLName name, DbType dbType) {
        this(new SQLExprTableSource(name), dbType);
    }

    public SQLDropTableStatement(SQLName name) {
        this(name, null);
    }

    public SQLDropTableStatement(SQLExprTableSource tableSource) {
        this(tableSource, null);
    }

    public SQLDropTableStatement(SQLExprTableSource tableSource, DbType dbType) {
        this(dbType);
        this.tableSources.add(tableSource);
    }

    public List<SQLExprTableSource> getTableSources() {
        return this.tableSources;
    }

    public void addPartition(SQLExprTableSource tableSource) {
        if (tableSource != null) {
            tableSource.setParent(this);
        }
        this.tableSources.add(tableSource);
    }

    public void setName(SQLName name) {
        this.addTableSource(new SQLExprTableSource(name));
    }

    public void addTableSource(String name) {
        this.addTableSource(new SQLIdentifierExpr(name));
    }

    public void addTableSource(SQLName name) {
        this.addTableSource(new SQLExprTableSource(name));
    }

    public void addTableSource(SQLExprTableSource tableSource) {
        this.tableSources.add(tableSource);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSources);
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        return this.tableSources;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    public void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    public boolean isRestrict() {
        return this.restrict;
    }

    public void setRestrict(boolean restrict) {
        this.restrict = restrict;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public List<SQLCommentHint> getHints() {
        return this.hints;
    }

    public void setHints(List<SQLCommentHint> hints) {
        this.hints = hints;
    }

    public boolean isDropPartition() {
        return this.isDropPartition;
    }

    public void setDropPartition(boolean dropPartition) {
        this.isDropPartition = dropPartition;
    }

    public SQLExpr getWhere() {
        return this.where;
    }

    public void setWhere(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.where = x;
    }

    @Override
    public SQLDDLStatement.DDLObjectType getDDLObjectType() {
        return SQLDDLStatement.DDLObjectType.TABLE;
    }

    @Override
    public SQLName getName() {
        if (this.tableSources.size() == 1) {
            SQLExprTableSource dataSource0 = this.tableSources.get(0);
            return dataSource0.getName();
        }
        return null;
    }

    protected void cloneTo(SQLDropTableStatement x) {
        if (this.hints != null) {
            x.hints = new ArrayList<SQLCommentHint>(this.hints);
        }
        this.tableSources.forEach(e -> x.addTableSource(e.clone()));
        x.purge = this.purge;
        x.cascade = this.cascade;
        x.restrict = this.restrict;
        x.ifExists = this.ifExists;
        x.temporary = this.temporary;
        x.external = this.external;
        x.isDropPartition = this.isDropPartition;
        if (this.where != null) {
            x.where = this.where.clone();
        }
    }

    @Override
    public SQLDropTableStatement clone() {
        SQLDropTableStatement x = new SQLDropTableStatement();
        this.cloneTo(x);
        return x;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLDropTableStatement that = (SQLDropTableStatement)o;
        return this.purge == that.purge && this.cascade == that.cascade && this.restrict == that.restrict && this.ifExists == that.ifExists && this.temporary == that.temporary && this.external == that.external && this.isDropPartition == that.isDropPartition && Objects.equals(this.hints, that.hints) && Objects.equals(this.tableSources, that.tableSources) && Objects.equals(this.where, that.where);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.hints);
        result = 31 * result + Objects.hashCode(this.tableSources);
        result = 31 * result + Boolean.hashCode(this.purge);
        result = 31 * result + Boolean.hashCode(this.cascade);
        result = 31 * result + Boolean.hashCode(this.restrict);
        result = 31 * result + Boolean.hashCode(this.ifExists);
        result = 31 * result + Boolean.hashCode(this.temporary);
        result = 31 * result + Boolean.hashCode(this.external);
        result = 31 * result + Boolean.hashCode(this.isDropPartition);
        result = 31 * result + Objects.hashCode(this.where);
        return result;
    }
}

