/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty;

import com.alibaba.nacos.shaded.com.google.common.base.Preconditions;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Connection;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2FrameWriter;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamBufferingEncoder;

interface ListeningEncoder {
    public void setListener(Http2OutboundFrameListener var1);

    public static final class ListeningDefaultHttp2ConnectionEncoder
    extends DefaultHttp2ConnectionEncoder
    implements ListeningEncoder {
        private Http2OutboundFrameListener listener = new Http2OutboundFrameListener();

        public ListeningDefaultHttp2ConnectionEncoder(Http2Connection connection, Http2FrameWriter frameWriter) {
            super(connection, frameWriter);
        }

        @Override
        public void setListener(Http2OutboundFrameListener listener) {
            this.listener = Preconditions.checkNotNull(listener, "listener");
        }

        @Override
        public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
            this.listener.onPing(ack, data);
            return super.writePing(ctx, ack, data, promise);
        }

        @Override
        public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
            this.listener.onWindowUpdate(streamId, windowSizeIncrement);
            return super.writeWindowUpdate(ctx, streamId, windowSizeIncrement, promise);
        }

        @Override
        public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean eos, ChannelPromise promise) {
            this.listener.onData(streamId, data, padding, eos);
            return super.writeData(ctx, streamId, data, padding, eos, promise);
        }
    }

    public static final class ListeningStreamBufferingEncoder
    extends StreamBufferingEncoder
    implements ListeningEncoder {
        private Http2OutboundFrameListener listener = new Http2OutboundFrameListener();

        public ListeningStreamBufferingEncoder(Http2ConnectionEncoder encoder) {
            super(encoder);
        }

        @Override
        public void setListener(Http2OutboundFrameListener listener) {
            this.listener = Preconditions.checkNotNull(listener, "listener");
        }

        @Override
        public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
            this.listener.onPing(ack, data);
            return super.writePing(ctx, ack, data, promise);
        }

        @Override
        public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
            this.listener.onWindowUpdate(streamId, windowSizeIncrement);
            return super.writeWindowUpdate(ctx, streamId, windowSizeIncrement, promise);
        }

        @Override
        public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean eos, ChannelPromise promise) {
            this.listener.onData(streamId, data, padding, eos);
            return super.writeData(ctx, streamId, data, padding, eos, promise);
        }
    }

    public static class Http2OutboundFrameListener {
        public void onWindowUpdate(int streamId, int windowSizeIncrement) {
        }

        public void onPing(boolean ack, long data) {
        }

        public void onData(int streamId, ByteBuf data, int padding, boolean endStream) {
        }
    }
}

