/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.ConnectionHolder;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;

public class ConnectionHolderFactory {
    public static ConnectionHolder getConnectionHolder(ConsumerBootstrap consumerBootstrap) {
        try {
            String connectionHolder = consumerBootstrap.getConsumerConfig().getConnectionHolder();
            ExtensionClass<ConnectionHolder> ext = ExtensionLoaderFactory.getExtensionLoader(ConnectionHolder.class).getExtensionClass(connectionHolder);
            if (ext == null) {
                throw ExceptionUtils.buildRuntime("consumer.connectionHolder", connectionHolder, "Unsupported connectionHolder of client!");
            }
            return ext.getExtInstance(new Class[]{ConsumerBootstrap.class}, new Object[]{consumerBootstrap});
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(e.getMessage(), e);
        }
    }
}

