/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.authority;

import com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSChannel;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Properties;

public class SessionCredentials {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String AccessKey = "AccessKey";
    public static final String SecretKey = "SecretKey";
    public static final String Signature = "Signature";
    public static final String SignatureMethod = "SignatureMethod";
    public static final String ONSChannelKey = "OnsChannel";
    public static final String KeyFile = System.getProperty("rocketmq.client.keyFile", System.getProperty("user.home") + File.separator + "onskey");
    private String accessKey;
    private String secretKey;
    private String signature;
    private String signatureMethod;
    private ONSChannel onsChannel = ONSChannel.ALIYUN;

    public SessionCredentials() {
        Properties prop;
        String keyContent = MixAll.file2String((String)KeyFile);
        if (keyContent != null && (prop = MixAll.string2Properties((String)keyContent)) != null) {
            this.updateContent(prop);
        }
    }

    public void updateContent(Properties prop) {
        Object value = prop.getProperty(AccessKey);
        if (value != null) {
            this.accessKey = ((String)value).trim();
        }
        if ((value = prop.getProperty(SecretKey)) != null) {
            this.secretKey = ((String)value).trim();
        }
        if ((value = prop.get(ONSChannelKey)) != null) {
            this.onsChannel = ONSChannel.valueOf(value.toString());
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public ONSChannel getOnsChannel() {
        return this.onsChannel;
    }

    public void setOnsChannel(ONSChannel onsChannel) {
        this.onsChannel = onsChannel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessKey == null ? 0 : this.accessKey.hashCode());
        result = 31 * result + (this.secretKey == null ? 0 : this.secretKey.hashCode());
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        result = 31 * result + (this.signatureMethod == null ? 0 : this.signatureMethod.hashCode());
        result = 31 * result + (this.onsChannel == null ? 0 : this.onsChannel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionCredentials other = (SessionCredentials)obj;
        if (this.accessKey == null ? other.accessKey != null : !this.accessKey.equals(other.accessKey)) {
            return false;
        }
        if (this.secretKey == null ? other.secretKey != null : !this.secretKey.equals(other.secretKey)) {
            return false;
        }
        if (this.signature == null ? other.signature != null : !this.signature.equals(other.signature)) {
            return false;
        }
        if (this.signatureMethod == null ? other.signatureMethod != null : !this.signatureMethod.equals(other.signatureMethod)) {
            return false;
        }
        return !(this.onsChannel == null ? other.onsChannel != null : !this.onsChannel.equals((Object)other.onsChannel));
    }

    public String toString() {
        return "SessionCredentials [accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", signature=" + this.signature + ", signatureMethod=" + this.signatureMethod + ", onsChannel=" + (Object)((Object)this.onsChannel) + "]";
    }
}

