/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.annotation.ImportantField;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.help.FAQUrl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;

public class MixAll {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqCommon");
    public static final String ROCKETMQ_HOME_ENV = "ROCKETMQ_HOME";
    public static final String ROCKETMQ_HOME_PROPERTY = "rocketmq.home.dir";
    public static final String NAMESRV_ADDR_ENV = "NAMESRV_ADDR";
    public static final String NAMESRV_ADDR_PROPERTY = "rocketmq.namesrv.addr";
    public static final String MESSAGE_COMPRESS_LEVEL = "rocketmq.message.compressLevel";
    public static final String DEFAULT_NAMESRV_ADDR_LOOKUP = "jmenv.tbsite.net";
    public static final String WS_DOMAIN_NAME = System.getProperty("rocketmq.namesrv.domain", "jmenv.tbsite.net");
    public static final String WS_DOMAIN_SUBGROUP = System.getProperty("rocketmq.namesrv.domain.subgroup", "nsaddr");
    public static final String DEFAULT_TOPIC = "TBW102";
    public static final String BENCHMARK_TOPIC = "BenchmarkTest";
    public static final String DEFAULT_PRODUCER_GROUP = "DEFAULT_PRODUCER";
    public static final String DEFAULT_CONSUMER_GROUP = "DEFAULT_CONSUMER";
    public static final String TOOLS_CONSUMER_GROUP = "TOOLS_CONSUMER";
    public static final String FILTERSRV_CONSUMER_GROUP = "FILTERSRV_CONSUMER";
    public static final String MONITOR_CONSUMER_GROUP = "__MONITOR_CONSUMER";
    public static final String CLIENT_INNER_PRODUCER_GROUP = "CLIENT_INNER_PRODUCER";
    public static final String SELF_TEST_PRODUCER_GROUP = "SELF_TEST_P_GROUP";
    public static final String SELF_TEST_CONSUMER_GROUP = "SELF_TEST_C_GROUP";
    public static final String SELF_TEST_TOPIC = "SELF_TEST_TOPIC";
    public static final String OFFSET_MOVED_EVENT = "OFFSET_MOVED_EVENT";
    public static final String ONS_HTTP_PROXY_GROUP = "CID_ONS-HTTP-PROXY";
    public static final String CID_ONSAPI_PERMISSION_GROUP = "CID_ONSAPI_PERMISSION";
    public static final String CID_ONSAPI_OWNER_GROUP = "CID_ONSAPI_OWNER";
    public static final String CID_ONSAPI_PULL_GROUP = "CID_ONSAPI_PULL";
    public static final String CID_RMQ_SYS_PREFIX = "CID_RMQ_SYS_";
    public static final List<String> LOCAL_INET_ADDRESS = MixAll.getLocalInetAddress();
    public static final String LOCALHOST = MixAll.localhost();
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final long MASTER_ID = 0L;
    public static final long CURRENT_JVM_PID = MixAll.getPID();
    public static final String RETRY_GROUP_TOPIC_PREFIX = "%RETRY%";
    public static final String DLQ_GROUP_TOPIC_PREFIX = "%DLQ%";
    public static final String SYSTEM_TOPIC_PREFIX = "rmq_sys_";
    public static final String UNIQUE_MSG_QUERY_FLAG = "_UNIQUE_KEY_QUERY";
    public static final String DEFAULT_TRACE_REGION_ID = "DefaultRegion";
    public static final String CONSUME_CONTEXT_TYPE = "ConsumeContextType";

    public static String getWSAddr() {
        String wsDomainName = System.getProperty("rocketmq.namesrv.domain", DEFAULT_NAMESRV_ADDR_LOOKUP);
        String wsDomainSubgroup = System.getProperty("rocketmq.namesrv.domain.subgroup", "nsaddr");
        String wsAddr = "http://" + wsDomainName + ":8080/rocketmq/" + wsDomainSubgroup;
        if (wsDomainName.indexOf(":") > 0) {
            wsAddr = "http://" + wsDomainName + "/rocketmq/" + wsDomainSubgroup;
        }
        return wsAddr;
    }

    public static String getRetryTopic(String consumerGroup) {
        return RETRY_GROUP_TOPIC_PREFIX + consumerGroup;
    }

    public static boolean isSysConsumerGroup(String consumerGroup) {
        return consumerGroup.startsWith(CID_RMQ_SYS_PREFIX);
    }

    public static boolean isSystemTopic(String topic) {
        return topic.startsWith(SYSTEM_TOPIC_PREFIX);
    }

    public static String getDLQTopic(String consumerGroup) {
        return DLQ_GROUP_TOPIC_PREFIX + consumerGroup;
    }

    public static String brokerVIPChannel(boolean isChange, String brokerAddr) {
        if (isChange) {
            String[] ipAndPort = brokerAddr.split(":");
            String brokerAddrNew = ipAndPort[0] + ":" + (Integer.parseInt(ipAndPort[1]) - 2);
            return brokerAddrNew;
        }
        return brokerAddr;
    }

    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (processName != null && processName.length() > 0) {
            try {
                return Long.parseLong(processName.split("@")[0]);
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static void string2File(String str, String fileName) throws IOException {
        String tmpFile = fileName + ".tmp";
        MixAll.string2FileNotSafe(str, tmpFile);
        String bakFile = fileName + ".bak";
        String prevContent = MixAll.file2String(fileName);
        if (prevContent != null) {
            MixAll.string2FileNotSafe(prevContent, bakFile);
        }
        File file = new File(fileName);
        file.delete();
        file = new File(tmpFile);
        file.renameTo(new File(fileName));
    }

    public static void string2FileNotSafe(String str, String fileName) throws IOException {
        File file = new File(fileName);
        File fileParent = file.getParentFile();
        if (fileParent != null) {
            fileParent.mkdirs();
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(str);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public static String file2String(String fileName) throws IOException {
        File file = new File(fileName);
        return MixAll.file2String(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(File file) throws IOException {
        if (file.exists()) {
            boolean result;
            byte[] data = new byte[(int)file.length()];
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                int len = inputStream.read(data);
                result = len == data.length;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (result) {
                return new String(data);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(URL url) {
        InputStream in = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            in = urlConnection.getInputStream();
            int len = in.available();
            byte[] data = new byte[len];
            in.read(data, 0, len);
            String string = new String(data, DEFAULT_CHARSET);
            return string;
        }
        catch (Exception ignored) {
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return null;
    }

    public static void printObjectProperties(InternalLogger logger, Object object) {
        MixAll.printObjectProperties(logger, object, false);
    }

    public static void printObjectProperties(InternalLogger logger, Object object, boolean onlyImportantField) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            ImportantField annotation;
            String name;
            if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(object);
                if (null == value) {
                    value = "";
                }
            }
            catch (IllegalAccessException e) {
                log.error("Failed to obtain object properties", e);
            }
            if (onlyImportantField && null == (annotation = field.getAnnotation(ImportantField.class)) || logger == null) continue;
            logger.info(name + "=" + value);
        }
    }

    public static String properties2String(Properties properties) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getValue() == null) continue;
            sb.append(entry.getKey().toString() + "=" + entry.getValue().toString() + "\n");
        }
        return sb.toString();
    }

    public static Properties string2Properties(String str) {
        Properties properties = new Properties();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes(DEFAULT_CHARSET));
            properties.load(in);
        }
        catch (Exception e) {
            log.error("Failed to handle properties", e);
            return null;
        }
        return properties;
    }

    public static Properties object2Properties(Object object) {
        Field[] fields;
        Properties properties = new Properties();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            String name;
            if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                log.error("Failed to handle properties", e);
            }
            if (value == null) continue;
            properties.setProperty(name, value.toString());
        }
        return properties;
    }

    public static void properties2Object(Properties p, Object object) {
        Method[] methods;
        for (Method method : methods = object.getClass().getMethods()) {
            String mn = method.getName();
            if (!mn.startsWith("set")) continue;
            try {
                Class<?>[] pt;
                String tmp = mn.substring(4);
                String first = mn.substring(3, 4);
                String key = first.toLowerCase() + tmp;
                String property = p.getProperty(key);
                if (property == null || (pt = method.getParameterTypes()) == null || pt.length <= 0) continue;
                String cn = pt[0].getSimpleName();
                Object arg = null;
                if (cn.equals("int") || cn.equals("Integer")) {
                    arg = Integer.parseInt(property);
                } else if (cn.equals("long") || cn.equals("Long")) {
                    arg = Long.parseLong(property);
                } else if (cn.equals("double") || cn.equals("Double")) {
                    arg = Double.parseDouble(property);
                } else if (cn.equals("boolean") || cn.equals("Boolean")) {
                    arg = Boolean.parseBoolean(property);
                } else if (cn.equals("float") || cn.equals("Float")) {
                    arg = Float.valueOf(Float.parseFloat(property));
                } else {
                    if (!cn.equals("String")) continue;
                    arg = property;
                }
                method.invoke(object, arg);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    public static boolean isPropertiesEqual(Properties p1, Properties p2) {
        return p1.equals(p2);
    }

    public static List<String> getLocalInetAddress() {
        ArrayList<String> inetAddressList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    inetAddressList.add(addrs.nextElement().getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("get local inet address fail", e);
        }
        return inetAddressList;
    }

    private static String localhost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Throwable e) {
            try {
                String candidatesHost = MixAll.getLocalhostByNetworkInterface();
                if (candidatesHost != null) {
                    return candidatesHost;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("InetAddress java.net.InetAddress.getLocalHost() throws UnknownHostException" + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), e);
        }
    }

    public static String getLocalhostByNetworkInterface() throws SocketException {
        ArrayList<String> candidatesHost = new ArrayList<String>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if ("docker0".equals(networkInterface.getName()) || !networkInterface.isUp()) continue;
            Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress address = addrs.nextElement();
                if (address.isLoopbackAddress()) continue;
                if (address instanceof Inet6Address) {
                    candidatesHost.add(address.getHostAddress());
                    continue;
                }
                return address.getHostAddress();
            }
        }
        if (!candidatesHost.isEmpty()) {
            return (String)candidatesHost.get(0);
        }
        return null;
    }

    public static boolean compareAndIncreaseOnly(AtomicLong target, long value) {
        long prev = target.get();
        while (value > prev) {
            boolean updated = target.compareAndSet(prev, value);
            if (updated) {
                return true;
            }
            prev = target.get();
        }
        return false;
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

