/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch;

import com.atomikos.icatch.CompositeTransaction;
import java.util.Properties;
import java.util.Stack;

public class Propagation {
    public static final String VERSION = "2019";
    private final Stack<CompositeTransaction> lineage;
    private final boolean serial;
    private final long timeout;
    private final String recoveryDomainName;
    private final String recoveryCoordinatorUri;

    public Propagation(String recoveryDomainName, CompositeTransaction rootTransaction, CompositeTransaction parentTransaction, boolean serial, long timeout) {
        this(recoveryDomainName, rootTransaction, parentTransaction, serial, timeout, null);
    }

    public Propagation(String recoveryDomainName, CompositeTransaction rootTransaction, CompositeTransaction parentTransaction, boolean serial, long timeout, String recoveryCoordinatorUri) {
        if (rootTransaction == null) {
            throw new IllegalArgumentException("rootTransaction cannot be null");
        }
        if (parentTransaction == null) {
            throw new IllegalArgumentException("parentTransaction cannot be null");
        }
        if (recoveryCoordinatorUri == null) {
            recoveryCoordinatorUri = parentTransaction.getTid();
        }
        this.timeout = timeout;
        this.serial = serial;
        this.recoveryDomainName = recoveryDomainName;
        this.lineage = new Stack();
        this.lineage.push(rootTransaction);
        this.lineage.push(parentTransaction);
        this.recoveryCoordinatorUri = recoveryCoordinatorUri;
    }

    public String getRecoveryDomainName() {
        return this.recoveryDomainName;
    }

    public CompositeTransaction getRootTransaction() {
        return (CompositeTransaction)this.getLineage().firstElement();
    }

    public CompositeTransaction getParentTransaction() {
        return (CompositeTransaction)this.lineage.lastElement();
    }

    public Stack<CompositeTransaction> getLineage() {
        return this.lineage;
    }

    public boolean isSerial() {
        return this.serial;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getRecoveryCoordinatorURI() {
        return this.recoveryCoordinatorUri;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("version=").append(VERSION).append(",");
        ret.append("domain=").append(this.recoveryDomainName).append(",");
        ret.append("timeout=").append(this.getTimeout()).append(",");
        ret.append("serial=").append(this.isSerial()).append(",");
        ret.append("recoveryCoordinatorURI=").append(this.recoveryCoordinatorUri).append(",");
        this.addParent(this.getRootTransaction(), ret);
        if (!this.getRootTransaction().isSameTransaction(this.getParentTransaction())) {
            ret.append(",");
            this.addParent(this.getParentTransaction(), ret);
        }
        return ret.toString();
    }

    private void addParent(CompositeTransaction parent, StringBuffer buf) {
        buf.append("parent=").append(parent.getTid());
        Properties p = parent.getProperties();
        for (String key : p.stringPropertyNames()) {
            buf.append(",").append("property.").append(key).append("=").append(p.getProperty(key));
        }
    }
}

