/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.jms.ConsumerProducerSupport;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

class AtomikosJmsMessageConsumerProxy
extends ConsumerProducerSupport
implements MessageConsumer {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosJmsMessageConsumerProxy.class);
    private MessageConsumer delegate;

    public AtomikosJmsMessageConsumerProxy(MessageConsumer delegate, SessionHandleState state) {
        super(state);
        this.delegate = delegate;
    }

    protected MessageConsumer getDelegate() {
        return this.delegate;
    }

    public Message receive() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": receive()...");
        }
        Message ret = null;
        try {
            this.enlist();
            ret = this.delegate.receive();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": receive returning " + ret);
        }
        return ret;
    }

    public Message receive(long timeout) throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": receive ( " + timeout + ")...");
        }
        Message ret = null;
        try {
            this.enlist();
            ret = this.delegate.receive(timeout);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": receive returning " + ret);
        }
        return ret;
    }

    public Message receiveNoWait() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": receiveNoWait()...");
        }
        Message ret = null;
        try {
            this.enlist();
            ret = this.delegate.receiveNoWait();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": receiveNoWait returning " + ret);
        }
        return ret;
    }

    public void close() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": close...");
        }
        try {
            this.delegate.close();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": close done.");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getMessageListener()...");
        }
        MessageListener ret = null;
        try {
            ret = this.delegate.getMessageListener();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": getMessageListener() returning " + ret);
        }
        return ret;
    }

    public String getMessageSelector() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getMessageSelector()...");
        }
        String ret = null;
        try {
            ret = this.delegate.getMessageSelector();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": getMessageSelector() returning " + ret);
        }
        return ret;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": setMessageListener ( " + listener + " )...");
        }
        try {
            this.delegate.setMessageListener(listener);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": setMessageListener done.");
        }
    }

    public String toString() {
        return "atomikos MessageConsumer proxy for " + this.delegate;
    }
}

