/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.extra;

import com.atomikos.jms.AtomikosConnectionFactoryBean;
import com.atomikos.jms.extra.MessageConsumerSession;
import com.atomikos.jms.extra.MessageConsumerSessionProperties;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;

public class MessageDrivenContainer
implements MessageConsumerSessionProperties {
    private static final Logger LOGGER = LoggerFactory.createLogger(MessageDrivenContainer.class);
    private static final int DEFAULT_TIMEOUT = 30;
    private AtomikosConnectionFactoryBean connectionFactoryBean;
    private MessageListener messageListener;
    private String user;
    private String password;
    private Destination destination;
    private String destinationName;
    private int transactionTimeout;
    private int poolSize;
    private List<MessageConsumerSession> sessions = new ArrayList<MessageConsumerSession>();
    private boolean daemonThreads;
    private boolean notifyListenerOnClose = false;
    private String messageSelector;
    private ExceptionListener exceptionListener;
    private String subscriberName;
    private boolean noLocal;
    private boolean unsubscribeOnClose;
    private String clientID;
    private int receiveTimeout;

    public MessageDrivenContainer() {
        this.setPoolSize(1);
        this.setTransactionTimeout(30);
    }

    private MessageConsumerSession createSession() {
        return new MessageConsumerSession(this);
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public void setAtomikosConnectionFactoryBean(AtomikosConnectionFactoryBean bean) {
        this.connectionFactoryBean = bean;
    }

    public AtomikosConnectionFactoryBean getAtomikosConnectionFactoryBean() {
        return this.connectionFactoryBean;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination dest) {
        this.destination = dest;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setDaemonThreads(boolean value) {
        this.daemonThreads = value;
    }

    public boolean getDaemonThreads() {
        return this.daemonThreads;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    @Override
    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setMessageListener(MessageListener listener) {
        this.messageListener = listener;
        for (MessageConsumerSession s : this.sessions) {
            s.setMessageListener(listener);
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setTransactionTimeout(int seconds) {
        this.transactionTimeout = seconds;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String selector) {
        this.messageSelector = selector;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int size) {
        this.poolSize = size;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public String getSubscriberName() {
        return this.subscriberName;
    }

    public void setSubscriberName(String subscriberName) {
        this.subscriberName = subscriberName;
    }

    protected boolean getNoLocal() {
        return this.isNoLocal();
    }

    public void start() throws JMSException {
        if (this.destination == null && this.destinationName == null) {
            throw new JMSException("MessageDrivenContainer: destination not specified");
        }
        if (this.connectionFactoryBean == null) {
            throw new JMSException("MessageDrivenContainer: factory not set");
        }
        if (this.messageListener == null) {
            throw new JMSException("MessageDrivenContainer: messageListener not set");
        }
        for (int i = 0; i < this.poolSize; ++i) {
            MessageConsumerSession s = this.createSession();
            s.setMessageListener(this.messageListener);
            s.setPassword(this.password);
            s.setUser(this.user);
            s.setDestination(this.destination);
            s.setDestinationName(this.destinationName);
            s.setAtomikosConnectionFactoryBean(this.connectionFactoryBean);
            s.setDaemonThreads(this.daemonThreads);
            s.setNotifyListenerOnClose(this.notifyListenerOnClose);
            s.setMessageSelector(this.getMessageSelector());
            s.setExceptionListener(this.exceptionListener);
            s.setNoLocal(this.noLocal);
            s.setSubscriberName(this.subscriberName);
            if (this.getSubscriberName() != null) {
                s.setSubscriberName(this.getSubscriberName() + "-" + i);
            }
            s.setNoLocal(this.getNoLocal());
            s.setClientID(this.clientID);
            try {
                s.startListening();
            }
            catch (Exception e) {
                LOGGER.logFatal("Error starting pool", (Throwable)e);
            }
            this.sessions.add(s);
        }
        this.setMessageListener(this.messageListener);
    }

    public void stop() {
        for (MessageConsumerSession s : this.sessions) {
            s.stopListening();
        }
    }

    public boolean getNotifyListenerOnClose() {
        return this.notifyListenerOnClose;
    }

    public void setNotifyListenerOnClose(boolean b) {
        this.notifyListenerOnClose = b;
        for (MessageConsumerSession s : this.sessions) {
            s.setNotifyListenerOnClose(b);
        }
    }

    public void setUnsubscribeOnClose(boolean b) {
        this.unsubscribeOnClose = b;
    }

    @Override
    public boolean getUnsubscribeOnClose() {
        return this.unsubscribeOnClose;
    }

    @Override
    public int getReceiveTimeout() {
        int ret = this.receiveTimeout;
        if (ret <= 0) {
            ret = this.getTransactionTimeout() / 2;
        }
        return ret;
    }

    public void setReceiveTimeout(int seconds) {
        this.receiveTimeout = seconds;
    }
}

