/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console;

import com.bstek.urule.RuleException;
import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.KnowledgeBuilder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.ResourceItem;
import com.bstek.urule.console.repository.model.ResourcePackage;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.service.KnowledgePackageService;
import java.io.IOException;
import java.util.List;

public class DefaultKnowledgePackageService
implements KnowledgePackageService {
    private KnowledgeBuilder knowledgeBuilder;
    private RepositoryService repositoryService;

    public KnowledgePackage buildKnowledgePackage(String packageInfo) throws IOException {
        return this.buildKnowledgePackage(packageInfo, false);
    }

    public KnowledgePackage buildKnowledgePackage(String packageInfo, boolean withPermission) throws IOException {
        try {
            String[] info = packageInfo.split("/");
            if (info.length != 2) {
                throw new RuleException("PackageInfo [" + packageInfo + "] is invalid. Correct such as \"projectName/packageId\".");
            }
            String project = info[0];
            String packageId = info[1];
            List<ResourcePackage> packages = this.repositoryService.loadProjectResourcePackages(project);
            List<ResourceItem> list = null;
            for (ResourcePackage resourcePackage : packages) {
                if (!resourcePackage.getId().equals(packageId)) continue;
                list = resourcePackage.getResourceItems();
                break;
            }
            if (list == null) {
                throw new RuleException("PackageId [" + packageId + "] was not found in project [" + project + "].");
            }
            ResourceBase resourceBase = this.knowledgeBuilder.newResourceBase();
            for (ResourceItem item : list) {
                resourceBase.addResource(item.getPath(), item.getVersion(), withPermission);
            }
            KnowledgeBase knowledgeBase = this.knowledgeBuilder.buildKnowledgeBase(resourceBase, withPermission);
            KnowledgePackage knowledgePackage = knowledgeBase.getKnowledgePackage();
            return knowledgePackage;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    public void setKnowledgeBuilder(KnowledgeBuilder knowledgeBuilder) {
        this.knowledgeBuilder = knowledgeBuilder;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

